/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.automationhelpers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.context.ContextHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NxLabs
implements ContextHelper {
    public String getFileExtension(String path) {
        return FilenameUtils.getExtension((String)path);
    }

    public String getBaseName(String path) {
        return FilenameUtils.getBaseName((String)path);
    }

    public String getUserFullName(String userId) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        NuxeoPrincipal pcipal = userManager.getPrincipal(userId);
        if (pcipal == null) {
            return "";
        }
        Object fullName = "";
        String firstName = pcipal.getFirstName();
        String lastName = pcipal.getLastName();
        if (StringUtils.isNotBlank((CharSequence)firstName)) {
            fullName = firstName;
        }
        if (StringUtils.isNotBlank((CharSequence)lastName)) {
            if (StringUtils.isNotBlank((CharSequence)firstName)) {
                fullName = (String)fullName + " ";
            }
            fullName = (String)fullName + lastName;
        }
        if (StringUtils.isBlank((CharSequence)fullName)) {
            fullName = userId;
        }
        return fullName;
    }

    public void commitAndStartTransaction() {
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
    }

    public void threadSleep(long ms) throws InterruptedException {
        Thread.sleep(ms);
    }

    public String md5(Blob blob) throws IOException {
        if (blob == null) {
            return "";
        }
        InputStream in = blob.getStream();
        return DigestUtils.md5Hex((InputStream)in);
    }

    public String base64(Blob blob) throws IOException {
        if (blob == null) {
            return "";
        }
        return Base64.getEncoder().encodeToString(blob.getByteArray());
    }

    public String base64(String str) {
        if (str == null) {
            return "";
        }
        return Base64.getEncoder().encodeToString(str.getBytes());
    }
}

