/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations.blobs;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;

@Operation(id="Labs.BlobGetMimeType", category="Files", label="Get Blob Mime-Type", description="Return the mimetype of the input blob inthe nxlabs_mimetype Context Variable. Important: the operation first sniffs the binary, even if blob.getMimeType() if not empty, or the file name has a valid extension.If the service fails to get the mimetype, set nxlabs_mimetype to null and details in the log as an error. Returns the input blob unchanged. Notice this call can be costly, the input blob temporarily duplicated on disk, etc.")
public class BlobGetMimeType {
    public static final String ID = "Labs.BlobGetMimeType";
    private static final Logger log = LogManager.getLogger(BlobGetMimeType.class);
    public static final String CTX_VAR_NAME = "nxlabs_mimetype";
    @Context
    protected OperationContext ctx;
    @Context
    protected MimetypeRegistry mimetypeService;
    @Param(name="varName", required=false)
    protected String varName;

    @OperationMethod
    public Blob run(Blob input) {
        String mimeType = null;
        try {
            mimeType = this.mimetypeService.getMimetypeFromBlob(input);
        }
        catch (Exception e) {
            if ("no registered mimetype has extension: bin".equals(e.getMessage())) {
                try {
                    String fileName = input.getFilename();
                    String ext = FilenameUtils.getExtension((String)fileName);
                    if (StringUtils.isNotBlank((CharSequence)fileName) && StringUtils.isNotBlank((CharSequence)ext)) {
                        mimeType = this.mimetypeService.getMimetypeFromFilename(fileName);
                        log.warn("Mime type (" + mimeType + ") from filename (" + fileName + "), not from sniffing the blob");
                    }
                    log.error("Failed to get the mimetype", (Throwable)e);
                    mimeType = null;
                }
                catch (Exception e2) {
                    log.error("Failed to get the mimetype", (Throwable)e2);
                    mimeType = null;
                }
            }
            log.error("Failed to get the mimetype", (Throwable)e);
            mimeType = null;
        }
        this.ctx.put(CTX_VAR_NAME, (Object)mimeType);
        return input;
    }
}

