/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations.pictures;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.PictureViewImpl;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;

@Operation(id="Labs.PictureAddToViews", category="Document", label="Add blob to picture:views", description="Add a new view (viewName) to the picture:views field of the document referenced by the document parameter (id or path). If viewName already exists, it is replaced. If fileName is not passed, the blob's file name is used. If the document does not have the picture schema, the operation does nothing. Returns the modified document (saved if saveDoc is passed and true). Notice the description is what is displayed in the UI. If not passed, the operation uses the viewName.")
public class PictureAddToViews {
    public static final String ID = "Labs.PictureAddToViews";
    @Context
    protected CoreSession session;
    @Context
    protected ImagingService imagingService;
    @Param(name="document", required=true)
    protected DocumentModel doc;
    @Param(name="viewName", required=true)
    protected String viewName;
    @Param(name="description", required=false)
    protected String description;
    @Param(name="fileName", required=false)
    protected String fileName;
    @Param(name="saveDoc", required=false)
    protected Boolean saveDoc = false;

    @OperationMethod
    public DocumentModel run(Blob input) {
        if (this.doc.hasSchema("picture")) {
            if (StringUtils.isEmpty((CharSequence)this.fileName)) {
                this.fileName = input.getFilename();
            }
            if (StringUtils.isEmpty((CharSequence)this.description)) {
                this.description = this.viewName;
            }
            ImageInfo info = this.imagingService.getImageInfo(input);
            PictureViewImpl view = new PictureViewImpl();
            view.setBlob(input);
            view.setDescription(this.description);
            view.setFilename(this.fileName);
            view.setHeight(info.getHeight());
            view.setImageInfo(info);
            view.setTitle(this.viewName);
            view.setWidth(info.getWidth());
            MultiviewPicture mvp = (MultiviewPicture)this.doc.getAdapter(MultiviewPicture.class);
            mvp.addView((PictureView)view);
            if (this.saveDoc.booleanValue()) {
                this.doc = this.session.saveDocument(this.doc);
            }
        }
        return this.doc;
    }
}

