/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations.videos;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Labs.VideoRemoveFromTranscodedVideos", category="Document", label="Remove from Transcoded Videos", description="Remove an entry from vid:transcodedVideos. If renditionName is not found orif the document does not have the video schema, the operation does nothing. Returns the modified document (saved if saveDoc is passed and true). ")
public class VideoRemoveFromTranscodedVideos {
    public static final String ID = "Labs.VideoRemoveFromTranscodedVideos";
    public static final String TRANSCODED_VIDEOS_FIELD = "vid:transcodedVideos";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Param(name="renditionName", required=true)
    protected String renditionName;
    @Param(name="saveDoc", required=false)
    protected Boolean saveDoc = false;

    @OperationMethod
    public DocumentModel run(DocumentModel input) {
        if (!input.hasSchema("video")) {
            return input;
        }
        List transcodedVideos = (List)((Object)input.getPropertyValue(TRANSCODED_VIDEOS_FIELD));
        if (transcodedVideos != null) {
            transcodedVideos = transcodedVideos.stream().filter(map -> !this.renditionName.equals(map.get("name"))).collect(Collectors.toList());
            input.setPropertyValue(TRANSCODED_VIDEOS_FIELD, (Serializable)((Object)transcodedVideos));
            if (this.saveDoc.booleanValue()) {
                input = this.session.saveDocument(input);
            }
        }
        return input;
    }
}

