/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jxls.controller.WorkbookTransformationController;
import net.sf.jxls.controller.WorkbookTransformationControllerImpl;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.formula.CommonFormulaResolver;
import net.sf.jxls.formula.Formula;
import net.sf.jxls.formula.FormulaController;
import net.sf.jxls.formula.FormulaPart;
import net.sf.jxls.formula.FormulaResolver;
import net.sf.jxls.parser.ExpressionCollectionParser;
import net.sf.jxls.processor.CellProcessor;
import net.sf.jxls.processor.PropertyPreprocessor;
import net.sf.jxls.processor.RowProcessor;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.Sheet;
import net.sf.jxls.transformer.SheetTransformer;
import net.sf.jxls.transformer.Workbook;
import net.sf.jxls.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class XLSTransformer {
    protected static final Log log = LogFactory.getLog(XLSTransformer.class);
    private List propertyPreprocessors = new ArrayList();
    private List rowProcessors = new ArrayList();
    private List cellProcessors = new ArrayList();
    private short[] columnsToHide;
    private Set spreadsheetsToRemove = new HashSet();
    private Map spreadsheetsToRename = new HashMap();
    private String[] columnPropertyNamesToHide;
    Map customTags = new HashMap();
    private Set fixedSizeCollections = new HashSet();
    private Set groupedCollections = new HashSet();
    private Configuration configuration;
    private WorkbookTransformationController workbookTransformationController;
    private FormulaResolver formulaResolver;

    public void registerPropertyPreprocessor(PropertyPreprocessor propPreprocessor) {
        if (propPreprocessor != null) {
            this.propertyPreprocessors.add(propPreprocessor);
        }
    }

    public void registerRowProcessor(RowProcessor rowProcessor) {
        if (rowProcessor != null) {
            this.rowProcessors.add(rowProcessor);
        }
    }

    public void registerCellProcessor(CellProcessor cellProcessor) {
        if (cellProcessor != null) {
            this.cellProcessors.add(cellProcessor);
        }
    }

    public void markAsFixedSizeCollection(String collectionName) {
        this.fixedSizeCollections.add(collectionName);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public XLSTransformer() {
        this(new Configuration());
    }

    public XLSTransformer(Configuration configuration) {
        this.configuration = configuration != null ? configuration : new Configuration();
    }

    public FormulaResolver getFormulaResolver() {
        return this.formulaResolver;
    }

    public void setFormulaResolver(FormulaResolver formulaResolver) {
        this.formulaResolver = formulaResolver;
    }

    public boolean isJexlInnerCollectionsAccess() {
        return this.configuration.isJexlInnerCollectionsAccess();
    }

    public void setJexlInnerCollectionsAccess(boolean jexlInnerCollectionsAccess) {
        this.configuration.setJexlInnerCollectionsAccess(jexlInnerCollectionsAccess);
    }

    public void groupCollection(String collectionName) {
        this.groupedCollections.add(collectionName);
    }

    public void transformXLS(String srcFilePath, Map beanParams, String destFilePath) throws ParsePropertyException, IOException, InvalidFormatException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(srcFilePath));
        org.apache.poi.ss.usermodel.Workbook workbook = this.transformXLS(is, beanParams);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destFilePath));
        workbook.write((OutputStream)os);
        ((InputStream)is).close();
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }

    public org.apache.poi.ss.usermodel.Workbook transformXLS(InputStream is, Map beanParams) throws ParsePropertyException, InvalidFormatException {
        org.apache.poi.ss.usermodel.Workbook hssfWorkbook = null;
        try {
            hssfWorkbook = WorkbookFactory.create((InputStream)is);
            this.transformWorkbook(hssfWorkbook, beanParams);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return hssfWorkbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformWorkbook(org.apache.poi.ss.usermodel.Workbook hssfWorkbook, Map beanParams) {
        try {
            String spreadsheetName;
            int sheetNo;
            Workbook workbook = this.createWorkbook(hssfWorkbook);
            this.exposePOIObjects(workbook, beanParams);
            this.workbookTransformationController = new WorkbookTransformationControllerImpl(workbook);
            this.preprocess(hssfWorkbook);
            SheetTransformer sheetTransformer = new SheetTransformer(this.fixedSizeCollections, this.groupedCollections, this.rowProcessors, this.cellProcessors, this.configuration);
            ArrayList<String> excludedSheets = new ArrayList<String>();
            for (sheetNo = 0; sheetNo < hssfWorkbook.getNumberOfSheets(); ++sheetNo) {
                spreadsheetName = hssfWorkbook.getSheetName(sheetNo);
                if (spreadsheetName == null || this.configuration.getExcludeSheets().contains(spreadsheetName)) continue;
                if (!spreadsheetName.startsWith(this.configuration.getExcludeSheetProcessingMark())) {
                    if (!this.isSpreadsheetToRemove(spreadsheetName)) {
                        if (this.isSpreadsheetToRename(spreadsheetName)) {
                            hssfWorkbook.setSheetName(sheetNo, this.getSpreadsheetToReName(spreadsheetName));
                        }
                        Sheet sheet = workbook.getSheetAt(sheetNo);
                        sheetTransformer.transformSheet(this.workbookTransformationController, sheet, beanParams);
                        continue;
                    }
                    workbook.removeSheetAt(sheetNo);
                    --sheetNo;
                    continue;
                }
                excludedSheets.add(spreadsheetName);
            }
            if (this.configuration.isRemoveExcludeSheetProcessingMark()) {
                for (sheetNo = 0; sheetNo < excludedSheets.size(); ++sheetNo) {
                    spreadsheetName = (String)excludedSheets.get(0);
                    hssfWorkbook.setSheetName(hssfWorkbook.getSheetIndex(spreadsheetName), spreadsheetName.substring(this.configuration.getExcludeSheetProcessingMark().length()));
                }
            }
            this.updateFormulas();
        }
        finally {
            Formula.clearCache();
            FormulaPart.clearCache();
            ExpressionCollectionParser.clearCache();
        }
    }

    private void exposePOIObjects(Workbook workbook, Map beanParams) {
        beanParams.put(this.configuration.getWorkbookKeyName(), workbook.getPoiWorkbook());
    }

    public org.apache.poi.ss.usermodel.Workbook transformMultipleSheetsList(InputStream is, List objects, List newSheetNames, String beanName, Map beanParams, int startSheetNum) throws ParsePropertyException, InvalidFormatException {
        org.apache.poi.ss.usermodel.Workbook hssfWorkbook = null;
        try {
            if (beanParams != null && beanParams.containsKey(beanName)) {
                throw new IllegalArgumentException("Selected bean name '" + beanName + "' already exists in the bean map");
            }
            if (beanName == null) {
                throw new IllegalArgumentException("Bean name must not be null");
            }
            if (beanParams == null) {
                beanParams = new HashMap();
            }
            hssfWorkbook = WorkbookFactory.create((InputStream)is);
            for (int sheetNo = 0; sheetNo < hssfWorkbook.getNumberOfSheets(); ++sheetNo) {
                String spreadsheetName = hssfWorkbook.getSheetName(sheetNo);
                if (!this.isSpreadsheetToRemove(spreadsheetName)) {
                    if (this.isSpreadsheetToRename(spreadsheetName)) {
                        hssfWorkbook.setSheetName(sheetNo, this.getSpreadsheetToReName(spreadsheetName));
                    }
                    org.apache.poi.ss.usermodel.Sheet hssfSheet = hssfWorkbook.getSheetAt(sheetNo);
                    if (startSheetNum != sheetNo || objects == null || objects.isEmpty()) continue;
                    int c2 = objects.size();
                    for (int i = 0; i < c2; ++i) {
                        Object bean = objects.get(i);
                        String beanKey = beanName;
                        if (i != 0) {
                            beanKey = beanName + i;
                            org.apache.poi.ss.usermodel.Sheet newSheet = hssfWorkbook.createSheet((String)newSheetNames.get(i));
                            Util.copySheets(newSheet, hssfSheet, beanName, beanKey);
                            Util.copyPageSetup(newSheet, hssfSheet);
                            Util.copyPrintSetup(newSheet, hssfSheet);
                        } else {
                            hssfWorkbook.setSheetName(sheetNo, (String)newSheetNames.get(i));
                        }
                        beanParams.put(beanKey, bean);
                    }
                    continue;
                }
                hssfWorkbook.removeSheetAt(sheetNo);
                --sheetNo;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (hssfWorkbook != null) {
            for (int i = 0; i < hssfWorkbook.getNumberOfSheets(); ++i) {
                Util.setPrintArea(hssfWorkbook, i);
            }
        }
        this.transformWorkbook(hssfWorkbook, beanParams);
        return hssfWorkbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.apache.poi.ss.usermodel.Workbook transformXLS(InputStream is, List templateSheetNameList, List sheetNameList, List beanParamsList) throws ParsePropertyException, InvalidFormatException {
        org.apache.poi.ss.usermodel.Workbook hssfWorkbook = null;
        try {
            hssfWorkbook = WorkbookFactory.create((InputStream)is);
            int numberOfSheets = hssfWorkbook.getNumberOfSheets();
            int c = templateSheetNameList.size();
            block5: for (int templateSheetIndex = 0; templateSheetIndex < c; ++templateSheetIndex) {
                String templateSheetName = (String)templateSheetNameList.get(templateSheetIndex);
                String sheetName = (String)sheetNameList.get(templateSheetIndex);
                for (int workbookSheetIndex = 0; workbookSheetIndex < numberOfSheets; ++workbookSheetIndex) {
                    if (!templateSheetName.equals(hssfWorkbook.getSheetName(workbookSheetIndex))) continue;
                    this.cloneSheet(hssfWorkbook, workbookSheetIndex, sheetName);
                    continue block5;
                }
            }
            for (int i = 0; i < numberOfSheets; ++i) {
                hssfWorkbook.removeSheetAt(0);
            }
            Workbook workbook = this.createWorkbook(hssfWorkbook);
            this.workbookTransformationController = new WorkbookTransformationControllerImpl(workbook);
            this.preprocess(hssfWorkbook);
            SheetTransformer sheetTransformer = new SheetTransformer(this.fixedSizeCollections, this.groupedCollections, this.rowProcessors, this.cellProcessors, this.configuration);
            for (int sheetNo = 0; sheetNo < workbook.getNumberOfSheets(); ++sheetNo) {
                String spreadsheetName = hssfWorkbook.getSheetName(sheetNo);
                if (!this.isSpreadsheetToRemove(spreadsheetName)) {
                    if (this.isSpreadsheetToRename(spreadsheetName)) {
                        hssfWorkbook.setSheetName(sheetNo, this.getSpreadsheetToReName(spreadsheetName));
                    }
                    Sheet sheet = workbook.getSheetAt(sheetNo);
                    Map beanParams = (Map)beanParamsList.get(sheetNo);
                    beanParams.put("index", String.valueOf(sheetNo));
                    this.exposePOIObjects(workbook, beanParams);
                    sheetTransformer.transformSheet(this.workbookTransformationController, sheet, beanParams);
                    continue;
                }
                workbook.removeSheetAt(sheetNo);
                --sheetNo;
            }
            this.updateFormulas();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Formula.clearCache();
            FormulaPart.clearCache();
            ExpressionCollectionParser.clearCache();
        }
        return hssfWorkbook;
    }

    private void cloneSheet(org.apache.poi.ss.usermodel.Workbook hssfWorkbook, int index, String name) {
        org.apache.poi.ss.usermodel.Sheet hssfSheet = hssfWorkbook.cloneSheet(index);
        for (int i = 0; i < hssfWorkbook.getNumberOfSheets(); ++i) {
            if (!hssfSheet.equals(hssfWorkbook.getSheetAt(i))) continue;
            hssfWorkbook.setSheetName(i, name);
            break;
        }
    }

    private Workbook createWorkbook(org.apache.poi.ss.usermodel.Workbook hssfWorkbook) {
        Workbook workbook = new Workbook(hssfWorkbook);
        for (int sheetNo = 0; sheetNo < hssfWorkbook.getNumberOfSheets(); ++sheetNo) {
            org.apache.poi.ss.usermodel.Sheet hssfSheet = hssfWorkbook.getSheetAt(sheetNo);
            workbook.addSheet(new Sheet(hssfWorkbook, hssfSheet, this.configuration));
        }
        workbook.initSheetNames();
        workbook.createFormulaController();
        return workbook;
    }

    private void updateFormulas() {
        if (this.formulaResolver == null) {
            this.formulaResolver = new CommonFormulaResolver();
        }
        FormulaController formulaController = this.workbookTransformationController.getWorkbook().getFormulaController();
        formulaController.writeFormulas(this.formulaResolver);
    }

    private void preprocess(org.apache.poi.ss.usermodel.Workbook workbook) {
        this.hideColumns(workbook);
        this.hideColumnsByPropertyName(workbook);
        for (int sheet_no = 0; sheet_no < workbook.getNumberOfSheets(); ++sheet_no) {
            org.apache.poi.ss.usermodel.Sheet sheet = workbook.getSheetAt(sheet_no);
            int c2 = sheet.getLastRowNum();
            for (int i = sheet.getFirstRowNum(); i <= c2; ++i) {
                Row hssfRow = sheet.getRow(i);
                if (hssfRow == null || hssfRow.getFirstCellNum() < 0 || hssfRow.getLastCellNum() < 0) continue;
                short c3 = hssfRow.getLastCellNum();
                for (int j = hssfRow.getFirstCellNum(); j <= c3; ++j) {
                    Cell cell = hssfRow.getCell(j);
                    if (cell == null || cell.getCellType() != CellType.STRING) continue;
                    String value = cell.getRichStringCellValue().getString();
                    int c4 = this.propertyPreprocessors.size();
                    for (int k = 0; k < c4; ++k) {
                        PropertyPreprocessor propertyPreprocessor = (PropertyPreprocessor)this.propertyPreprocessors.get(k);
                        String newValue = propertyPreprocessor.processProperty(value);
                        if (newValue == null) continue;
                        cell.setCellValue(workbook.getCreationHelper().createRichTextString(newValue));
                    }
                }
            }
        }
    }

    private void hideColumns(org.apache.poi.ss.usermodel.Workbook workbook) {
        if (this.columnsToHide != null) {
            for (int i = 0; i < this.columnsToHide.length; ++i) {
                short column = this.columnsToHide[i];
                for (int sheet_no = 0; sheet_no < workbook.getNumberOfSheets(); ++sheet_no) {
                    org.apache.poi.ss.usermodel.Sheet sheet = workbook.getSheetAt(sheet_no);
                    sheet.setColumnWidth((int)column, 0);
                }
            }
        }
    }

    private void hideColumnsByPropertyName(org.apache.poi.ss.usermodel.Workbook workbook) {
        if (this.columnPropertyNamesToHide == null) {
            return;
        }
        for (int sheet_no = 0; sheet_no < workbook.getNumberOfSheets(); ++sheet_no) {
            org.apache.poi.ss.usermodel.Sheet sheet = workbook.getSheetAt(sheet_no);
            int c2 = sheet.getLastRowNum();
            for (int i = sheet.getFirstRowNum(); i <= c2; ++i) {
                Row hssfRow = sheet.getRow(i);
                if (hssfRow == null || hssfRow.getFirstCellNum() < 0 || hssfRow.getLastCellNum() < 0) continue;
                short c3 = hssfRow.getLastCellNum();
                block2: for (int j = hssfRow.getFirstCellNum(); j <= c3; ++j) {
                    Cell cell = hssfRow.getCell(j);
                    if (cell == null || cell.getCellType() != CellType.STRING) continue;
                    String value = cell.getRichStringCellValue().getString();
                    for (int prptIndx = 0; prptIndx < this.columnPropertyNamesToHide.length; ++prptIndx) {
                        if (value == null || value.indexOf(this.columnPropertyNamesToHide[prptIndx]) == -1) continue;
                        sheet.setColumnWidth(j, 0);
                        continue block2;
                    }
                }
            }
        }
    }

    public short[] getColumnsToHide() {
        return this.columnsToHide;
    }

    public void setColumnsToHide(short[] columnsToHide) {
        this.columnsToHide = columnsToHide;
    }

    public String[] getColumnPropertyNamesToHide() {
        return this.columnPropertyNamesToHide;
    }

    public void setColumnPropertyNamesToHide(String[] columnPropertyNamesToHide) {
        this.columnPropertyNamesToHide = columnPropertyNamesToHide;
    }

    public void setSpreadsheetsToRemove(String[] names) {
        this.spreadsheetsToRemove.clear();
        for (int i = 0; i < names.length; ++i) {
            this.spreadsheetsToRemove.add(names[i]);
        }
    }

    public void setSpreadsheetToRename(String name, String newName) {
        this.spreadsheetsToRename.put(name, newName);
    }

    protected boolean isSpreadsheetToRemove(String name) {
        return this.spreadsheetsToRemove.contains(name);
    }

    protected boolean isSpreadsheetToRename(String name) {
        return this.spreadsheetsToRename.containsKey(name);
    }

    protected String getSpreadsheetToReName(String name) {
        String newName = (String)this.spreadsheetsToRename.get(name);
        if (newName != null) {
            return newName;
        }
        return name;
    }
}

