/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations;

import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.VAlarm;
import biweekly.component.VEvent;
import biweekly.io.text.ICalWriter;
import biweekly.parameter.Related;
import biweekly.property.Trigger;
import biweekly.util.Duration;
import java.io.IOException;
import java.util.Calendar;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.PeriodAndDuration;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;

@Operation(id="Labs.CreateICS", category="Services", label="Create .ics File", description="Creates an .ics blob from the parameters. label and startDate are required. For the end date, you can pass either endDate or duration, which is a java Period (like PT1H30M). Also, if fullDays is true, endDate and duration are optional location is a string, like 'Room 1'. Can be a link to a Zoom or Teams meeting, etc. organizerMail is a string. If not passed, most calendar applications will consider current user as the organizer. attendees is a list of emails, separated by a comma. alarm is a java period, only days, hours and minutes accepted. P1DT2H30M (1 day, 2 hours, 30mn) Warning: dates must be provided either as Java Calendar object or an ISO date string, make sure to specify a timezone.")
public class CreateICS {
    public static final String ID = "Labs.CreateICS";
    @Param(name="label", required=true)
    protected String label;
    @Param(name="startDate", required=true)
    Calendar startDate;
    @Param(name="endDate", required=false)
    Calendar endDate;
    @Param(name="duration", required=false)
    String duration;
    @Param(name="fullDays", required=false)
    Boolean fullDays = false;
    @Param(name="description", required=false)
    protected String description;
    @Param(name="location", required=false)
    protected String location;
    @Param(name="url", required=false)
    protected String url;
    @Param(name="organizerMail", required=false)
    protected String organizerMail;
    @Param(name="attendees", required=false)
    String attendees;
    @Param(name="alarm", required=false)
    protected String alarm;

    @OperationMethod
    public Blob run() {
        Blob icsBlob;
        ICalendar ical = new ICalendar();
        VEvent event = new VEvent();
        event.setSummary(this.label);
        if (this.fullDays.booleanValue()) {
            event.setDateStart(this.startDate.getTime(), false);
        } else {
            event.setDateStart(this.startDate.getTime());
        }
        if (!this.fullDays.booleanValue() && this.endDate == null && StringUtils.isBlank((CharSequence)this.duration)) {
            throw new IllegalArgumentException("Both endDate and duration cannot be empty");
        }
        if (this.endDate != null) {
            event.setDateEnd(this.endDate.getTime());
            if (this.fullDays.booleanValue()) {
                event.setDateEnd(this.endDate.getTime(), false);
            } else {
                event.setDateEnd(this.endDate.getTime());
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.duration)) {
            event.setDuration(Duration.parse((String)this.duration));
        }
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            event.setDescription(this.description);
        }
        if (StringUtils.isNotBlank((CharSequence)this.location)) {
            event.setLocation(this.location);
        }
        if (StringUtils.isNotBlank((CharSequence)this.url)) {
            event.setUrl(this.url);
        }
        if (StringUtils.isNotBlank((CharSequence)this.organizerMail)) {
            event.setOrganizer(this.organizerMail);
        }
        if (StringUtils.isNotBlank((CharSequence)this.attendees)) {
            String[] attendeesArray;
            for (String attendee : attendeesArray = this.attendees.split(",")) {
                attendee = attendee.trim();
                event.addAttendee(attendee);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.alarm)) {
            PeriodAndDuration pd = PeriodAndDuration.parse((String)this.alarm);
            int days = Math.abs(pd.period.getDays());
            int hours = Math.abs(pd.duration.toHoursPart());
            int minutes = Math.abs(pd.duration.toMinutesPart());
            Duration duration = Duration.builder().prior(true).days(Integer.valueOf(days)).hours(Integer.valueOf(hours)).minutes(Integer.valueOf(minutes)).build();
            Trigger trigger = new Trigger(duration, Related.START);
            VAlarm eventAlarm = VAlarm.display((Trigger)trigger, (String)"");
            event.addAlarm(eventAlarm);
        }
        event.setUid(UUID.randomUUID().toString());
        ical.addEvent(event);
        try {
            icsBlob = Blobs.createBlobWithExtension((String)".ics");
            try (ICalWriter iCalWriter = new ICalWriter(icsBlob.getFile(), ICalVersion.V2_0);){
                iCalWriter.write(ical);
                icsBlob.setMimeType("text/calendar");
                this.label = FileUtils.getSafeFilename((String)this.label);
                icsBlob.setFilename(this.label + ".ics");
            }
            catch (IOException e) {
                throw new NuxeoException("Error writing the ics file", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new NuxeoException("Error creating/writing the ics file", (Throwable)e);
        }
        return icsBlob;
    }
}

