/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations.blobs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.LazyBinary;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Labs.VerifyBinaryHash", category="Files", label="Check Binary by Hash", description="digest parameter is required if no inbput blob is passed. If input is a blob, digest is ignored. If the blob has a digest, uses it else calculates a md5 digest for the blob. Check to see if a binary with the digest is found within the system. Returns the same digest if found, null otherwise.")
public class VerifyBinaryHash {
    public static final String ID = "Labs.VerifyBinaryHash";
    @Context
    protected CoreSession session;
    @Param(name="digest", required=false)
    protected String digest;
    @Param(name="provider", required=false)
    protected String provider;

    @OperationMethod
    public String run(Blob blob) throws IOException {
        this.digest = blob.getDigest();
        if (StringUtils.isBlank((CharSequence)this.digest)) {
            InputStream in = blob.getStream();
            this.digest = DigestUtils.md5Hex((InputStream)in);
        }
        return this.run();
    }

    @OperationMethod
    public String run() {
        if (StringUtils.isBlank((CharSequence)this.digest)) {
            throw new IllegalArgumentException("digest parameter( is required when no blob is passed as input.");
        }
        BlobManager mgr = (BlobManager)Framework.getService(BlobManager.class);
        Map providers = mgr.getBlobProviders();
        if (this.provider != null) {
            BlobProvider bp = (BlobProvider)providers.get(this.provider);
            BinaryManager bmgr = bp.getBinaryManager();
            if (bmgr != null) {
                return this.checkDigest(bmgr);
            }
        } else {
            for (Map.Entry prov : providers.entrySet()) {
                BlobProvider bp = (BlobProvider)prov.getValue();
                BinaryManager bmgr = bp.getBinaryManager();
                if (bmgr == null) continue;
                return this.checkDigest(bmgr);
            }
        }
        return null;
    }

    private String checkDigest(BinaryManager bmgr) {
        Binary bin = bmgr.getBinary(this.digest);
        if (bin != null) {
            if (bin instanceof LazyBinary && ((LazyBinary)bin).getFile() != null) {
                return this.digest;
            }
            return this.digest;
        }
        return null;
    }
}

