/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations.pictures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;

@Operation(id="Labs.ConcatenateImages", category="Conversion", label="Concatenate Images", description="Concatenates images found at files:files. destMimeType is required, and so is targetFileName, which must also contains the file extension. concatHorizontally is optional. By default, concatenation is vertical. If there is only one blob, it is returned unchanged, not converted.")
public class ConcatenateImages {
    public static final String ID = "Labs.ConcatenateImages";
    private static final Logger log = LogManager.getLogger(ConcatenateImages.class);
    public static final String DEFAULT_XPATH = "files:files";
    @Context
    ConversionService conversionService;
    @Param(name="targetFileName", required=true)
    protected String targetFileName;
    @Param(name="destMimeType", required=true)
    protected String destMimeType;
    @Param(name="concatHorizontally", required=false)
    protected Boolean concatHorizontally = false;

    @OperationMethod
    public Blob run(DocumentModel input) {
        Blob result = null;
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        List files = (List)((Object)input.getPropertyValue(DEFAULT_XPATH));
        for (Map map : files) {
            Blob blob = (Blob)map.get("file");
            blobs.add(blob);
        }
        result = this.run(new BlobList(blobs));
        return result;
    }

    @OperationMethod
    public Blob run(BlobList blobs) {
        Blob result = null;
        if (blobs == null || blobs.size() == 0) {
            log.warn("No blob to process");
            return null;
        }
        if (blobs.size() == 1) {
            Blob blob = (Blob)blobs.get(0);
            String fileName = blob.getFilename();
            if (fileName == null) {
                fileName = "";
            }
            String ext = FilenameUtils.getExtension((String)fileName).toLowerCase();
            String destExt = FilenameUtils.getExtension((String)this.targetFileName).toLowerCase();
            if (StringUtils.equalsAny((CharSequence)ext, (CharSequence[])new CharSequence[]{"jpg", "jpeg"}) && StringUtils.equalsAny((CharSequence)destExt, (CharSequence[])new CharSequence[]{"jpg", "jpeg"})) {
                ext = destExt;
            }
            String mimeType = blob.getMimeType();
            Blob convertedBlob = null;
            if (!StringUtils.equals((CharSequence)ext, (CharSequence)destExt) || !StringUtils.equals((CharSequence)mimeType, (CharSequence)this.destMimeType)) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("targetFileName", this.targetFileName);
                BlobHolder holder = this.conversionService.convert("simpleConverterByFileName", (BlobHolder)new SimpleBlobHolder(blob), params);
                convertedBlob = holder.getBlob();
            } else {
                convertedBlob = blob;
            }
            return convertedBlob;
        }
        result = this.concatenate((Blob)blobs.get(0), (Blob)blobs.get(1));
        for (int i = 2; i < blobs.size(); ++i) {
            result = this.concatenate(result, (Blob)blobs.get(i));
        }
        return result;
    }

    protected Blob concatenate(Blob b1, Blob b2) {
        ArrayList<Blob> twoBlobs = new ArrayList<Blob>();
        twoBlobs.add(b1);
        twoBlobs.add(b2);
        SimpleBlobHolder sbh = new SimpleBlobHolder(twoBlobs);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetFileName", this.targetFileName);
        params.put("destMimeType", this.destMimeType);
        if (this.concatHorizontally != null && this.concatHorizontally.booleanValue()) {
            params.put("horizontalAppend", "true");
        }
        BlobHolder result = this.conversionService.convert("concatenateImages", (BlobHolder)sbh, params);
        Blob resultBlob = result.getBlob();
        return resultBlob;
    }
}

