/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors;

import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.platform.rendering.fm.adapters.DocumentObjectWrapper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.ContentInputType;
import org.nuxeo.template.api.InputType;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.processors.HtmlBodyExtractor;
import org.nuxeo.template.processors.InputBindingResolver;

public abstract class AbstractBindingResolver
implements InputBindingResolver {
    private static final Logger log = LogManager.getLogger(AbstractBindingResolver.class);
    protected DocumentObjectWrapper nuxeoWrapper = new DocumentObjectWrapper(null);

    protected abstract Object handleLoop(String var1, Object var2);

    protected abstract Object handlePictureField(String var1, Blob var2);

    protected abstract void handleBlobField(String var1, Blob var2);

    protected String handleHtmlField(String paramName, String htmlValue) {
        return HtmlBodyExtractor.extractHtmlBody(htmlValue);
    }

    protected DocumentObjectWrapper getWrapper() {
        return this.nuxeoWrapper;
    }

    @Override
    public void resolve(List<TemplateInput> inputParams, Map<String, Object> context, TemplateBasedDocument templateBasedDocument) {
        for (TemplateInput param : inputParams) {
            try {
                Object value = this.extractValueFromParam(templateBasedDocument, param);
                context.put(param.getName(), value);
            }
            catch (ValueNotFound e) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((TemplateInput)param).getName();
                log.warn("Unable to handle binding for param: {}", supplierArray);
                log.debug((Object)e, (Throwable)((Object)e));
            }
            catch (NoValueToAddInContext e) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((TemplateInput)param).getName();
                log.warn("Skip param to add: {} ", supplierArray);
                log.debug((Object)e, (Throwable)((Object)e));
            }
        }
    }

    protected Object extractValueFromParam(TemplateBasedDocument templateBasedDocument, TemplateInput param) {
        DocumentModel doc = templateBasedDocument.getAdaptedDoc();
        String propKey = param.getSource();
        switch (param.getType()) {
            case BooleanValue: {
                return param.getBooleanValue();
            }
            case DateValue: {
                return param.getDateValue();
            }
            case StringValue: {
                return param.getStringValue();
            }
            case MapValue: {
                HashMap resultMap = new HashMap();
                param.getMapValue().entrySet().forEach(entry -> {
                    try {
                        resultMap.put((String)entry.getKey(), this.extractValueFromParam(templateBasedDocument, (TemplateInput)entry.getValue()));
                    }
                    catch (NoValueToAddInContext | ValueNotFound e) {
                        Supplier[] supplierArray = new Supplier[2];
                        supplierArray[0] = entry::getKey;
                        supplierArray[1] = () -> ((TemplateInput)param).getName();
                        log.warn("Skip param to add: {} in: {}", supplierArray);
                        log.debug((Object)e, (Throwable)e);
                    }
                });
                return resultMap;
            }
            case ListValue: {
                ArrayList resultList = new ArrayList();
                param.getListValue().forEach(p -> {
                    try {
                        resultList.add(this.extractValueFromParam(templateBasedDocument, (TemplateInput)p));
                    }
                    catch (NoValueToAddInContext | ValueNotFound e) {
                        Supplier[] supplierArray = new Supplier[2];
                        supplierArray[0] = () -> ((TemplateInput)p).getName();
                        supplierArray[1] = () -> ((TemplateInput)param).getName();
                        log.warn("Skip param to add: {} in: {}", supplierArray);
                        log.debug((Object)e, (Throwable)e);
                    }
                });
                return resultList;
            }
            case Content: {
                ContentInputType contentInput = ContentInputType.getByValue((String)param.getSource());
                if (ContentInputType.BlobContent.equals((Object)contentInput)) {
                    return this.extractBlobContent(doc, param);
                }
                if (ContentInputType.HtmlPreview.equals((Object)contentInput)) {
                    return this.extractHTMLPreview(doc, param);
                }
                Serializable docPropertyValue = this.getDocPropertyValue(doc, propKey);
                if (!(docPropertyValue instanceof String)) break;
                return this.handleHtmlField(param.getName(), (String)((Object)this.getDocPropertyValue(doc, propKey)));
            }
            case PictureProperty: {
                try {
                    Serializable docPropertyValue = this.getDocPropertyValue(doc, propKey);
                    if (this.isBlob(docPropertyValue)) {
                        Blob blob = (Blob)this.getDocPropertyValue(doc, propKey);
                        this.addDefaultMimetypeIfRequired(blob);
                        return this.handlePictureField(param.getName(), blob);
                    }
                    break;
                }
                catch (ValueNotFound e) {
                    return this.handlePictureField(param.getName(), null);
                }
            }
        }
        Serializable docPropertyValue = this.getDocPropertyValue(doc, propKey);
        if (docPropertyValue == null) {
            return this.extractBlobContent(doc, param);
        }
        if (this.isBlob(this.getDocPropertyValue(doc, propKey))) {
            throw new NoValueToAddInContext();
        }
        Property property = this.getDocProperty(param, doc);
        if (param.isAutoLoop()) {
            return this.extractAutoLoop(param, property);
        }
        try {
            return this.nuxeoWrapper.wrap((Object)property);
        }
        catch (TemplateModelException e) {
            throw new ValueNotFound((Exception)((Object)e));
        }
    }

    protected void addDefaultMimetypeIfRequired(Blob blob) {
        if (StringUtils.isBlank((CharSequence)blob.getMimeType())) {
            blob.setMimeType("image/jpeg");
        }
    }

    protected Object extractAutoLoop(TemplateInput param, Property property) {
        return this.handleLoop(param.getName(), property);
    }

    protected Object extractBlobContent(DocumentModel doc, TemplateInput param) {
        Serializable propValue = this.getDocPropertyValue(doc, param.getSource());
        if (propValue instanceof Blob) {
            Blob blobValue = (Blob)propValue;
            this.handleBlobField(param.getName(), blobValue);
            try {
                return blobValue.getString();
            }
            catch (IOException e) {
                log.warn("Unable to handle binding for param: {}", (Object)param.getName(), (Object)e);
                return "";
            }
        }
        return this.extractDefaultValue(doc, param);
    }

    protected String extractHTMLPreview(DocumentModel doc, TemplateInput param) {
        try {
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            return this.handleHtmlField(param.getName(), this.getHtmlValue(bh));
        }
        catch (IOException e) {
            log.warn("Unable to handle binding for param: {}", (Object)param.getName(), (Object)e);
            return null;
        }
    }

    protected Object extractDefaultValue(DocumentModel doc, TemplateInput param) {
        if (param.getType().equals((Object)InputType.PictureProperty)) {
            return this.handlePictureField(param.getName(), null);
        }
        try {
            Property property = doc.getProperty(param.getSource());
            if (property != null) {
                Type pType = property.getType();
                if (pType.getName().equals("boolean")) {
                    return Boolean.FALSE;
                }
                if (pType.getName().equals("date")) {
                    return new Date();
                }
                if (pType.getName().equals("string")) {
                    return "";
                }
                if (pType.getName().equals(InputType.Content.getValue())) {
                    return "";
                }
                return "!NOVALUE!";
            }
        }
        catch (PropertyNotFoundException e) {
            throw new ValueNotFound((Exception)((Object)e));
        }
        throw new ValueNotFound();
    }

    protected Property getDocProperty(TemplateInput param, DocumentModel doc) {
        Property property;
        try {
            property = doc.getProperty(param.getSource());
        }
        catch (PropertyException e) {
            throw new ValueNotFound((Exception)((Object)e));
        }
        return property;
    }

    protected Serializable getDocPropertyValue(DocumentModel doc, String propKey) {
        try {
            return doc.getPropertyValue(propKey);
        }
        catch (PropertyException e) {
            throw new ValueNotFound((Exception)((Object)e));
        }
    }

    protected boolean isBlob(Serializable propValue) {
        return propValue != null && Blob.class.isAssignableFrom(propValue.getClass());
    }

    protected String getHtmlValue(BlobHolder bh) throws IOException {
        if (bh == null) {
            return "";
        }
        Blob blob = bh.getBlob();
        if (blob != null && "text/html".equals(blob.getMimeType())) {
            return blob.getString();
        }
        ConversionService conversion = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder htmlBh = conversion.convertToMimeType("text/html", bh, Collections.emptyMap());
        if (htmlBh != null) {
            return htmlBh.getBlob().getString();
        }
        if (blob != null && blob.getMimeType() != null && blob.getMimeType().startsWith("text/")) {
            return blob.getString();
        }
        return "";
    }

    protected static class ValueNotFound
    extends NuxeoException {
        public ValueNotFound(Exception e) {
            super((Throwable)e);
        }

        public ValueNotFound() {
        }
    }

    protected static class NoValueToAddInContext
    extends NuxeoException {
        protected NoValueToAddInContext() {
        }
    }
}

