/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.utils;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageSelections;
import org.nuxeo.runtime.api.Framework;

public class StringListPageProvider
extends AbstractPageProvider<DocumentModel>
implements PageProvider<DocumentModel> {
    private static final long serialVersionUID = 1L;
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String CURRENT_DOCUMENT_PROPERTY = "currentDoc";
    public static final String XPATH_PROPERTY = "xpath";
    protected static final Log log = LogFactory.getLog(StringListPageProvider.class);

    protected CoreSession getCoreSession() {
        Object session = this.getProperties().get(CORE_SESSION_PROPERTY);
        if (session != null && session instanceof CoreSession) {
            return (CoreSession)session;
        }
        return null;
    }

    protected DocumentModel getCurrentDocument() {
        Object docObj = this.getProperties().get(CURRENT_DOCUMENT_PROPERTY);
        if (docObj != null && docObj instanceof DocumentModel) {
            return (DocumentModel)docObj;
        }
        return null;
    }

    protected String getXPath() {
        Object docObj = this.getProperties().get(XPATH_PROPERTY);
        if (docObj != null && docObj instanceof String) {
            return (String)docObj;
        }
        return null;
    }

    public PageSelections<DocumentModel> getCurrentSelectPage() {
        return super.getCurrentSelectPage();
    }

    public List<DocumentModel> getCurrentPage() {
        DocumentModelListImpl docs = new DocumentModelListImpl();
        CoreSession session = this.getCoreSession();
        if (session == null) {
            log.error((Object)"No core session available in the context of this PageProvider");
            return docs;
        }
        DocumentModel doc = this.getCurrentDocument();
        if (doc == null) {
            log.error((Object)"No current document available in the context of this PageProvider");
            return docs;
        }
        String xpath = this.getXPath();
        if (StringUtils.isBlank((CharSequence)xpath)) {
            if (((CollectionManager)Framework.getService(CollectionManager.class)).isCollection(doc)) {
                xpath = "collection:documentIds";
            } else {
                log.error((Object)"No xpath provided for this PageProvider, and current document is not a collection");
                return docs;
            }
        }
        doc.refresh();
        String[] uuids = (String[])doc.getPropertyValue(xpath);
        if (uuids != null && uuids.length > 0) {
            for (String uid : uuids) {
                DocumentModel subDoc = session.getDocument((DocumentRef)new IdRef(uid));
                docs.add((Object)subDoc);
            }
        }
        return docs;
    }
}

