/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.CalendarGetScheduleBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.CalendarGetScheduleCollectionPage;
import com.microsoft.graph.requests.extensions.CalendarGetScheduleCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.CalendarGetScheduleCollectionResponse;
import com.microsoft.graph.requests.extensions.ICalendarGetScheduleCollectionPage;
import com.microsoft.graph.requests.extensions.ICalendarGetScheduleCollectionRequest;
import java.util.List;

public class CalendarGetScheduleCollectionRequest
extends BaseCollectionRequest<CalendarGetScheduleCollectionResponse, ICalendarGetScheduleCollectionPage>
implements ICalendarGetScheduleCollectionRequest {
    protected final CalendarGetScheduleBody body = new CalendarGetScheduleBody();

    public CalendarGetScheduleCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CalendarGetScheduleCollectionResponse.class, ICalendarGetScheduleCollectionPage.class);
    }

    @Override
    public void post(final ICallback<? super ICalendarGetScheduleCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(CalendarGetScheduleCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ICalendarGetScheduleCollectionPage post() throws ClientException {
        CalendarGetScheduleCollectionResponse response = (CalendarGetScheduleCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public ICalendarGetScheduleCollectionPage buildFromResponse(CalendarGetScheduleCollectionResponse response) {
        CalendarGetScheduleCollectionRequestBuilder builder = response.nextLink != null ? new CalendarGetScheduleCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null, null, null, null) : null;
        CalendarGetScheduleCollectionPage page = new CalendarGetScheduleCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public ICalendarGetScheduleCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICalendarGetScheduleCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ICalendarGetScheduleCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ICalendarGetScheduleCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public ICalendarGetScheduleCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

