/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore;

import com.microsoft.graph.httpcore.middlewareoption.IShouldRetry;
import com.microsoft.graph.httpcore.middlewareoption.MiddlewareType;
import com.microsoft.graph.httpcore.middlewareoption.RetryOptions;
import com.microsoft.graph.httpcore.middlewareoption.TelemetryOptions;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryHandler
implements Interceptor {
    public final MiddlewareType MIDDLEWARE_TYPE = MiddlewareType.RETRY;
    private RetryOptions mRetryOption;
    private final String RETRY_ATTEMPT_HEADER = "Retry-Attempt";
    private final String RETRY_AFTER = "Retry-After";
    private final String TRANSFER_ENCODING = "Transfer-Encoding";
    private final String TRANSFER_ENCODING_CHUNKED = "chunked";
    private final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private final String CONTENT_TYPE = "Content-Type";
    public static final int MSClientErrorCodeTooManyRequests = 429;
    public static final int MSClientErrorCodeServiceUnavailable = 503;
    public static final int MSClientErrorCodeGatewayTimeout = 504;
    private final long DELAY_MILLISECONDS = 1000L;

    public RetryHandler(RetryOptions retryOption) {
        this.mRetryOption = retryOption;
        if (this.mRetryOption == null) {
            this.mRetryOption = new RetryOptions();
        }
    }

    public RetryHandler() {
        this(null);
    }

    boolean retryRequest(Response response, int executionCount, Request request, RetryOptions retryOptions) {
        IShouldRetry shouldRetryCallback = null;
        if (retryOptions != null) {
            shouldRetryCallback = retryOptions.shouldRetry();
        }
        boolean shouldRetry = false;
        int statusCode = response.code();
        boolean bl = shouldRetry = executionCount <= retryOptions.maxRetries() && this.checkStatus(statusCode) && this.isBuffered(response, request) && shouldRetryCallback != null && shouldRetryCallback.shouldRetry(retryOptions.delay(), executionCount, request, response);
        if (shouldRetry) {
            long retryInterval = this.getRetryAfter(response, retryOptions.delay(), executionCount);
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return shouldRetry;
    }

    long getRetryAfter(Response response, long delay, int executionCount) {
        String retryAfterHeader = response.header("Retry-After");
        double retryDelay = 3000.0;
        if (retryAfterHeader != null) {
            retryDelay = Long.parseLong(retryAfterHeader) * 1000L;
        } else {
            retryDelay = (Math.pow(2.0, executionCount) - 1.0) * 0.5;
            retryDelay = (executionCount < 2 ? (double)delay : retryDelay + (double)delay) + Math.random();
            retryDelay *= 1000.0;
        }
        return (long)Math.min(retryDelay, 180000.0);
    }

    boolean checkStatus(int statusCode) {
        return statusCode == 429 || statusCode == 503 || statusCode == 504;
    }

    boolean isBuffered(Response response, Request request) {
        boolean isHTTPMethodPutPatchOrPost;
        String methodName = request.method();
        if (methodName.equalsIgnoreCase("GET") || methodName.equalsIgnoreCase("DELETE") || methodName.equalsIgnoreCase("HEAD") || methodName.equalsIgnoreCase("OPTIONS")) {
            return true;
        }
        boolean bl = isHTTPMethodPutPatchOrPost = methodName.equalsIgnoreCase("POST") || methodName.equalsIgnoreCase("PUT") || methodName.equalsIgnoreCase("PATCH");
        if (isHTTPMethodPutPatchOrPost) {
            boolean isStream;
            boolean bl2 = isStream = response.header("Content-Type") != null && response.header("Content-Type").equalsIgnoreCase("application/octet-stream");
            if (!isStream) {
                boolean isTransferEncodingChunked;
                String transferEncoding = response.header("Transfer-Encoding");
                boolean bl3 = isTransferEncodingChunked = transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked");
                if (request.body() != null && isTransferEncodingChunked) {
                    return true;
                }
            }
        }
        return false;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.tag(TelemetryOptions.class) == null) {
            request = request.newBuilder().tag(TelemetryOptions.class, (Object)new TelemetryOptions()).build();
        }
        ((TelemetryOptions)request.tag(TelemetryOptions.class)).setFeatureUsage(2);
        Response response = chain.proceed(request);
        RetryOptions retryOption = (RetryOptions)request.tag(RetryOptions.class);
        retryOption = retryOption != null ? retryOption : this.mRetryOption;
        int executionCount = 1;
        while (this.retryRequest(response, executionCount, request, retryOption)) {
            request = request.newBuilder().addHeader("Retry-Attempt", String.valueOf(executionCount)).build();
            ++executionCount;
            if (response != null && response.body() != null) {
                response.body().close();
            }
            response = chain.proceed(request);
        }
        return response;
    }
}

