/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.graph.options.HeaderOption;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;

public class Multipart {
    private String boundary;
    private static final String RETURN = "\r\n";
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    public static final String MULTIPART_ENCODING = "US-ASCII";
    private String contentType = "multipart/form-data";

    public Multipart() {
        this.boundary = "part_" + new BigInteger(130, new SecureRandom()).toString();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public void setBoundary(String boundary) {
        this.boundary = boundary;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public HeaderOption header() {
        return new HeaderOption("Content-Type", this.contentType + "; boundary=\"" + this.boundary + "\"");
    }

    private void writePartData(String partContent, byte[] byteArray) throws IOException {
        this.out.write(partContent.getBytes(MULTIPART_ENCODING));
        this.out.write(byteArray);
        String returnContent = "\r\n\r\n";
        this.out.write(returnContent.getBytes(MULTIPART_ENCODING));
    }

    @VisibleForTesting
    String createPartHeader(String name, String contentType, String filename) {
        StringBuilder partContent = new StringBuilder(this.addBoundary());
        partContent.append("Content-Disposition: form-data");
        if (filename != null) {
            if (name != null) {
                partContent.append("; name=\"").append(name).append("\"; filename=\"").append(filename).append("\"");
            } else {
                partContent.append("; filename=\"").append(filename).append("\"");
            }
        } else if (name != null) {
            partContent.append("; name=\"").append(name).append("\"");
        }
        if (contentType != null) {
            partContent.append(RETURN).append("Content-Type: ").append(contentType);
        }
        partContent.append(RETURN).append(RETURN);
        return partContent.toString();
    }

    public static String createContentHeaderValue(String contentValue, Map<String, String> contentDispParameter) {
        String contentHeaderValue = contentValue;
        if (contentDispParameter != null) {
            for (Map.Entry<String, String> entry : contentDispParameter.entrySet()) {
                contentHeaderValue = contentHeaderValue + ";" + entry.getKey() + "=\"" + entry.getValue() + "\"";
            }
        }
        return contentHeaderValue;
    }

    private String createPartHeader(Map<String, String> headers) {
        String partContent = this.addBoundary();
        String defaultPartContent = "Content-Disposition: form-data;\r\nContent-Type: " + this.contentType + RETURN + RETURN;
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                partContent = partContent + entry.getKey() + ": " + entry.getValue() + RETURN;
            }
            partContent = partContent + RETURN;
        } else {
            partContent = partContent + defaultPartContent;
        }
        return partContent;
    }

    private void addData(String name, String contentType, String filename, byte[] byteArray) throws IOException {
        String partContent = this.createPartHeader(name, contentType, filename);
        this.writePartData(partContent, byteArray);
    }

    public void addFormData(String name, String contentType, byte[] byteArray) throws IOException {
        this.addData(name, contentType, null, byteArray);
    }

    public void addPart(String contentType, byte[] byteArray) throws IOException {
        this.addData(null, contentType, null, byteArray);
    }

    public void addPart(Map<String, String> headers, byte[] content) throws IOException {
        String partContent = this.createPartHeader(headers);
        this.writePartData(partContent, content);
    }

    public void addHtmlPart(String name, byte[] content) throws IOException {
        this.addFormData(name, "text/html", content);
    }

    public void addFilePart(String name, String contentType, File file) throws IOException {
        FileInputStream fileStream = new FileInputStream(file);
        byte[] fileBytes = this.getByteArray(fileStream);
        this.addData(name, contentType, file.getName(), fileBytes);
    }

    private String addBoundary() {
        return "--" + this.boundary + RETURN;
    }

    private String addEnding() {
        return "--" + this.boundary + "--";
    }

    public byte[] content() throws IOException {
        ByteArrayOutputStream finalStream = this.out;
        finalStream.write(this.addEnding().getBytes(MULTIPART_ENCODING));
        return finalStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
        }
        finally {
            in.close();
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

