/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DirectoryRoleDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryRoleDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryRoleDeltaCollectionResponse;
import com.microsoft.graph.requests.extensions.IDirectoryRoleDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IDirectoryRoleDeltaCollectionRequest;
import java.util.List;

public class DirectoryRoleDeltaCollectionRequest
extends BaseCollectionRequest<DirectoryRoleDeltaCollectionResponse, IDirectoryRoleDeltaCollectionPage>
implements IDirectoryRoleDeltaCollectionRequest {
    public DirectoryRoleDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryRoleDeltaCollectionResponse.class, IDirectoryRoleDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDirectoryRoleDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DirectoryRoleDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryRoleDeltaCollectionPage get() throws ClientException {
        DirectoryRoleDeltaCollectionResponse response = (DirectoryRoleDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDirectoryRoleDeltaCollectionPage buildFromResponse(DirectoryRoleDeltaCollectionResponse response) {
        DirectoryRoleDeltaCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryRoleDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DirectoryRoleDeltaCollectionPage page = new DirectoryRoleDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDirectoryRoleDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDirectoryRoleDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDirectoryRoleDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IDirectoryRoleDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IDirectoryRoleDeltaCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

