/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.MobileApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppRequest;
import java.util.List;

public class MobileAppRequest
extends BaseRequest
implements IMobileAppRequest {
    public MobileAppRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends MobileApp> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public MobileAppRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileApp.class);
    }

    @Override
    public void get(ICallback<? super MobileApp> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public MobileApp get() throws ClientException {
        return (MobileApp)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super MobileApp> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(MobileApp sourceMobileApp, ICallback<? super MobileApp> callback) {
        this.send(HttpMethod.PATCH, callback, sourceMobileApp);
    }

    @Override
    public MobileApp patch(MobileApp sourceMobileApp) throws ClientException {
        return (MobileApp)this.send(HttpMethod.PATCH, sourceMobileApp);
    }

    @Override
    public void post(MobileApp newMobileApp, ICallback<? super MobileApp> callback) {
        this.send(HttpMethod.POST, callback, newMobileApp);
    }

    @Override
    public MobileApp post(MobileApp newMobileApp) throws ClientException {
        return (MobileApp)this.send(HttpMethod.POST, newMobileApp);
    }

    @Override
    public void put(MobileApp newMobileApp, ICallback<? super MobileApp> callback) {
        this.send(HttpMethod.PUT, callback, newMobileApp);
    }

    @Override
    public MobileApp put(MobileApp newMobileApp) throws ClientException {
        return (MobileApp)this.send(HttpMethod.PUT, newMobileApp);
    }

    @Override
    public IMobileAppRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMobileAppRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

