/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Chat;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IChatWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class ChatWithReferenceRequest
extends BaseRequest
implements IChatWithReferenceRequest {
    public ChatWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Chat.class);
    }

    @Override
    public void post(Chat newChat, IJsonBackedObject payload, ICallback<? super Chat> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public Chat post(Chat newChat, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newChat;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super Chat> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Chat get() throws ClientException {
        return (Chat)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Chat> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Chat sourceChat, ICallback<? super Chat> callback) {
        this.send(HttpMethod.PATCH, callback, sourceChat);
    }

    @Override
    public Chat patch(Chat sourceChat) throws ClientException {
        return (Chat)this.send(HttpMethod.PATCH, sourceChat);
    }

    @Override
    public IChatWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IChatWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

