/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EducationUserCollectionResponse;
import com.microsoft.graph.requests.extensions.EducationUserCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.EducationUserCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationUserCollectionPage;
import com.microsoft.graph.requests.extensions.IEducationUserCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IEducationUserCollectionWithReferencesRequest;
import java.util.List;

public class EducationUserCollectionWithReferencesRequest
extends BaseCollectionRequest<EducationUserCollectionResponse, IEducationUserCollectionPage>
implements IEducationUserCollectionWithReferencesRequest {
    public EducationUserCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationUserCollectionResponse.class, IEducationUserCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IEducationUserCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EducationUserCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationUserCollectionWithReferencesPage get() throws ClientException {
        EducationUserCollectionResponse response = (EducationUserCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IEducationUserCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IEducationUserCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IEducationUserCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IEducationUserCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEducationUserCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IEducationUserCollectionWithReferencesPage buildFromResponse(EducationUserCollectionResponse response) {
        EducationUserCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new EducationUserCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationUserCollectionWithReferencesPage page = new EducationUserCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

