/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Message;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMessageRequest;
import java.util.List;

public class MessageRequest
extends BaseRequest
implements IMessageRequest {
    public MessageRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends Message> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public MessageRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Message.class);
    }

    @Override
    public void get(ICallback<? super Message> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Message get() throws ClientException {
        return (Message)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Message> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Message sourceMessage, ICallback<? super Message> callback) {
        this.send(HttpMethod.PATCH, callback, sourceMessage);
    }

    @Override
    public Message patch(Message sourceMessage) throws ClientException {
        return (Message)this.send(HttpMethod.PATCH, sourceMessage);
    }

    @Override
    public void post(Message newMessage, ICallback<? super Message> callback) {
        this.send(HttpMethod.POST, callback, newMessage);
    }

    @Override
    public Message post(Message newMessage) throws ClientException {
        return (Message)this.send(HttpMethod.POST, newMessage);
    }

    @Override
    public void put(Message newMessage, ICallback<? super Message> callback) {
        this.send(HttpMethod.PUT, callback, newMessage);
    }

    @Override
    public Message put(Message newMessage) throws ClientException {
        return (Message)this.send(HttpMethod.PUT, newMessage);
    }

    @Override
    public IMessageRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMessageRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

