/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Application;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IApplicationWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class ApplicationWithReferenceRequest
extends BaseRequest
implements IApplicationWithReferenceRequest {
    public ApplicationWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Application.class);
    }

    @Override
    public void post(Application newApplication, IJsonBackedObject payload, ICallback<? super Application> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public Application post(Application newApplication, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newApplication;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super Application> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Application get() throws ClientException {
        return (Application)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Application> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Application sourceApplication, ICallback<? super Application> callback) {
        this.send(HttpMethod.PATCH, callback, sourceApplication);
    }

    @Override
    public Application patch(Application sourceApplication) throws ClientException {
        return (Application)this.send(HttpMethod.PATCH, sourceApplication);
    }

    @Override
    public IApplicationWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IApplicationWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

