/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.BaseItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IBaseItemRequest;
import java.util.List;

public class BaseItemRequest
extends BaseRequest
implements IBaseItemRequest {
    public BaseItemRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends BaseItem> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public BaseItemRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseItem.class);
    }

    @Override
    public void get(ICallback<? super BaseItem> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public BaseItem get() throws ClientException {
        return (BaseItem)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super BaseItem> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(BaseItem sourceBaseItem, ICallback<? super BaseItem> callback) {
        this.send(HttpMethod.PATCH, callback, sourceBaseItem);
    }

    @Override
    public BaseItem patch(BaseItem sourceBaseItem) throws ClientException {
        return (BaseItem)this.send(HttpMethod.PATCH, sourceBaseItem);
    }

    @Override
    public void post(BaseItem newBaseItem, ICallback<? super BaseItem> callback) {
        this.send(HttpMethod.POST, callback, newBaseItem);
    }

    @Override
    public BaseItem post(BaseItem newBaseItem) throws ClientException {
        return (BaseItem)this.send(HttpMethod.POST, newBaseItem);
    }

    @Override
    public void put(BaseItem newBaseItem, ICallback<? super BaseItem> callback) {
        this.send(HttpMethod.PUT, callback, newBaseItem);
    }

    @Override
    public BaseItem put(BaseItem newBaseItem) throws ClientException {
        return (BaseItem)this.send(HttpMethod.PUT, newBaseItem);
    }

    @Override
    public IBaseItemRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IBaseItemRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

