/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TokenIssuancePolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITokenIssuancePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ITokenIssuancePolicyCollectionRequest;
import com.microsoft.graph.requests.extensions.TokenIssuancePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.TokenIssuancePolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TokenIssuancePolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.TokenIssuancePolicyRequestBuilder;
import java.util.List;

public class TokenIssuancePolicyCollectionRequest
extends BaseCollectionRequest<TokenIssuancePolicyCollectionResponse, ITokenIssuancePolicyCollectionPage>
implements ITokenIssuancePolicyCollectionRequest {
    public TokenIssuancePolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TokenIssuancePolicyCollectionResponse.class, ITokenIssuancePolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ITokenIssuancePolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TokenIssuancePolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITokenIssuancePolicyCollectionPage get() throws ClientException {
        TokenIssuancePolicyCollectionResponse response = (TokenIssuancePolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TokenIssuancePolicy newTokenIssuancePolicy, ICallback<? super TokenIssuancePolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TokenIssuancePolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTokenIssuancePolicy, callback);
    }

    @Override
    public TokenIssuancePolicy post(TokenIssuancePolicy newTokenIssuancePolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TokenIssuancePolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTokenIssuancePolicy);
    }

    @Override
    public ITokenIssuancePolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITokenIssuancePolicyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ITokenIssuancePolicyCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ITokenIssuancePolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITokenIssuancePolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITokenIssuancePolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITokenIssuancePolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITokenIssuancePolicyCollectionPage buildFromResponse(TokenIssuancePolicyCollectionResponse response) {
        TokenIssuancePolicyCollectionRequestBuilder builder = response.nextLink != null ? new TokenIssuancePolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TokenIssuancePolicyCollectionPage page = new TokenIssuancePolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

