/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserGetManagedAppPoliciesCollectionPage;
import com.microsoft.graph.requests.extensions.IUserGetManagedAppPoliciesCollectionRequest;
import com.microsoft.graph.requests.extensions.UserGetManagedAppPoliciesCollectionPage;
import com.microsoft.graph.requests.extensions.UserGetManagedAppPoliciesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.UserGetManagedAppPoliciesCollectionResponse;
import java.util.List;

public class UserGetManagedAppPoliciesCollectionRequest
extends BaseCollectionRequest<UserGetManagedAppPoliciesCollectionResponse, IUserGetManagedAppPoliciesCollectionPage>
implements IUserGetManagedAppPoliciesCollectionRequest {
    public UserGetManagedAppPoliciesCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserGetManagedAppPoliciesCollectionResponse.class, IUserGetManagedAppPoliciesCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IUserGetManagedAppPoliciesCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(UserGetManagedAppPoliciesCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserGetManagedAppPoliciesCollectionPage get() throws ClientException {
        UserGetManagedAppPoliciesCollectionResponse response = (UserGetManagedAppPoliciesCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IUserGetManagedAppPoliciesCollectionPage buildFromResponse(UserGetManagedAppPoliciesCollectionResponse response) {
        UserGetManagedAppPoliciesCollectionRequestBuilder builder = response.nextLink != null ? new UserGetManagedAppPoliciesCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UserGetManagedAppPoliciesCollectionPage page = new UserGetManagedAppPoliciesCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IUserGetManagedAppPoliciesCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUserGetManagedAppPoliciesCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IUserGetManagedAppPoliciesCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IUserGetManagedAppPoliciesCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IUserGetManagedAppPoliciesCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

