/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.microsoft.graph.serializer.GsonFactory;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultSerializer
implements ISerializer {
    private final Gson gson;
    private final ILogger logger;
    private static final String graphResponseHeadersKey = "graphResponseHeaders";
    private static final String ODATA_TYPE_KEY = "@odata.type";

    public DefaultSerializer(ILogger logger) {
        this.logger = logger;
        this.gson = GsonFactory.getGsonInstance(logger);
    }

    @Override
    public <T> T deserializeObject(String inputString, Class<T> clazz) {
        return this.deserializeObject(inputString, clazz, null);
    }

    @Override
    public <T> T deserializeObject(String inputString, Class<T> clazz, Map<String, List<String>> responseHeaders) {
        Object jsonObject = this.gson.fromJson(inputString, clazz);
        if (jsonObject instanceof IJsonBackedObject) {
            Class<?> derivedClass;
            this.logger.logDebug("Deserializing type " + clazz.getSimpleName());
            JsonElement rawElement = (JsonElement)this.gson.fromJson(inputString, JsonElement.class);
            JsonObject rawObject = rawElement.isJsonObject() ? rawElement.getAsJsonObject() : null;
            Object jo = jsonObject;
            if (rawElement.isJsonObject() && (derivedClass = this.getDerivedClass(rawObject, clazz)) != null) {
                jo = this.gson.fromJson(inputString, derivedClass);
            }
            IJsonBackedObject jsonBackedObject = (IJsonBackedObject)jo;
            if (rawElement.isJsonObject()) {
                jsonBackedObject.setRawObject(this, rawObject);
                jsonBackedObject.additionalDataManager().setAdditionalData(rawObject);
                this.setChildAdditionalData(jsonBackedObject, rawObject);
            }
            if (responseHeaders != null) {
                JsonElement convertedHeaders = this.gson.toJsonTree(responseHeaders);
                jsonBackedObject.additionalDataManager().put(graphResponseHeadersKey, convertedHeaders);
            }
            return (T)jo;
        }
        this.logger.logDebug("Deserializing a non-IJsonBackedObject type " + clazz.getSimpleName());
        return (T)jsonObject;
    }

    private void setChildAdditionalData(IJsonBackedObject serializedObject, JsonObject rawJson) {
        if (rawJson != null) {
            for (Field field : serializedObject.getClass().getFields()) {
                try {
                    if (field == null) continue;
                    Object fieldObject = field.get(serializedObject);
                    if (fieldObject instanceof HashMap) {
                        HashMap serializableChildren = (HashMap)fieldObject;
                        for (Map.Entry pair : serializableChildren.entrySet()) {
                            Object child = pair.getValue();
                            if (!(child instanceof IJsonBackedObject)) continue;
                            AdditionalDataManager childAdditionalDataManager = ((IJsonBackedObject)child).additionalDataManager();
                            JsonElement fieldElement = rawJson.get(field.getName());
                            if (fieldElement == null || !fieldElement.isJsonObject() || fieldElement.getAsJsonObject().get((String)pair.getKey()) == null || !fieldElement.getAsJsonObject().get((String)pair.getKey()).isJsonObject()) continue;
                            childAdditionalDataManager.setAdditionalData(fieldElement.getAsJsonObject().get((String)pair.getKey()).getAsJsonObject());
                            this.setChildAdditionalData((IJsonBackedObject)child, fieldElement.getAsJsonObject().get((String)pair.getKey()).getAsJsonObject());
                        }
                        continue;
                    }
                    if (fieldObject instanceof List) {
                        JsonElement collectionJson = rawJson.get(field.getName());
                        List fieldObjectList = (List)fieldObject;
                        if (collectionJson == null || !collectionJson.isJsonArray()) continue;
                        JsonArray rawJsonArray = (JsonArray)collectionJson;
                        Integer fieldObjectListSize = fieldObjectList.size();
                        Integer rawJsonArraySize = rawJsonArray.size();
                        for (int i = 0; i < fieldObjectListSize && i < rawJsonArraySize; ++i) {
                            JsonElement elementRawJson;
                            Object element = fieldObjectList.get(i);
                            if (!(element instanceof IJsonBackedObject) || (elementRawJson = rawJsonArray.get(i)) == null) continue;
                            this.setChildAdditionalData((IJsonBackedObject)element, elementRawJson.getAsJsonObject());
                        }
                        if (rawJsonArraySize == fieldObjectListSize) continue;
                        this.logger.logDebug("rawJsonArray has a size of " + rawJsonArraySize + " and fieldObjectList of " + fieldObjectListSize);
                        continue;
                    }
                    if (!(fieldObject instanceof IJsonBackedObject)) continue;
                    IJsonBackedObject serializedChild = (IJsonBackedObject)fieldObject;
                    AdditionalDataManager childAdditionalDataManager = serializedChild.additionalDataManager();
                    JsonElement fieldElement = rawJson.get(field.getName());
                    if (fieldElement == null || !fieldElement.isJsonObject()) continue;
                    childAdditionalDataManager.setAdditionalData(fieldElement.getAsJsonObject());
                    this.setChildAdditionalData((IJsonBackedObject)fieldObject, fieldElement.getAsJsonObject());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    this.logger.logError("Unable to set child fields of " + serializedObject.getClass().getSimpleName(), e);
                    this.logger.logDebug(rawJson.getAsString());
                }
            }
        }
    }

    @Override
    public <T> String serializeObject(T serializableObject) {
        this.logger.logDebug("Serializing type " + serializableObject.getClass().getSimpleName());
        JsonElement outJsonTree = this.gson.toJsonTree(serializableObject);
        if (serializableObject instanceof IJsonBackedObject) {
            outJsonTree = this.getDataFromAdditionalDataManager(outJsonTree, serializableObject);
        } else if (outJsonTree.isJsonObject()) {
            Field[] fields = serializableObject.getClass().getDeclaredFields();
            JsonObject outJson = outJsonTree.getAsJsonObject();
            block2: for (Field field : fields) {
                Type[] interfaces;
                if (!outJson.has(field.getName())) continue;
                for (Type interfaceType : interfaces = field.getType().getGenericInterfaces()) {
                    if (interfaceType != IJsonBackedObject.class || !outJson.get(field.getName()).isJsonObject()) continue;
                    try {
                        JsonElement outdatedValue = outJson.remove(field.getName());
                        outJson.add(field.getName(), this.getDataFromAdditionalDataManager((JsonElement)outdatedValue.getAsJsonObject(), field.get(serializableObject)));
                    }
                    catch (IllegalAccessException ex) {
                        this.logger.logDebug("Couldn't access prop" + field.getName());
                    }
                    continue block2;
                }
            }
        }
        return outJsonTree.toString();
    }

    private <T> JsonElement getDataFromAdditionalDataManager(JsonElement outJsonTree, T serializableObject) {
        IJsonBackedObject serializableJsonObject = (IJsonBackedObject)serializableObject;
        AdditionalDataManager additionalData = serializableJsonObject.additionalDataManager();
        if (outJsonTree.isJsonObject()) {
            JsonObject outJson = outJsonTree.getAsJsonObject();
            this.addAdditionalDataFromManagerToJson(additionalData, outJson);
            this.getChildAdditionalData(serializableJsonObject, outJson);
            return outJson;
        }
        return outJsonTree;
    }

    private void getChildAdditionalData(IJsonBackedObject serializableObject, JsonObject outJson) {
        if (outJson == null) {
            return;
        }
        for (Field field : serializableObject.getClass().getFields()) {
            try {
                Object fieldObject = field.get(serializableObject);
                JsonElement fieldJsonElement = outJson.get(field.getName());
                if (fieldObject == null || field == null || fieldJsonElement == null) continue;
                if (fieldObject instanceof Map && fieldJsonElement.isJsonObject()) {
                    Map serializableChildren = (Map)fieldObject;
                    Iterator it = serializableChildren.entrySet().iterator();
                    JsonObject fieldJsonObject = fieldJsonElement.getAsJsonObject();
                    while (it.hasNext()) {
                        Map.Entry pair = it.next();
                        Object child = pair.getValue();
                        JsonElement childJsonElement = fieldJsonObject.get(((String)pair.getKey()).toString());
                        this.addAdditionalDataFromJsonElementToJson(child, childJsonElement);
                    }
                } else if (fieldObject instanceof List && fieldJsonElement.isJsonArray()) {
                    JsonArray fieldArrayValue = fieldJsonElement.getAsJsonArray();
                    List fieldObjectList = (List)fieldObject;
                    for (int index = 0; index < fieldObjectList.size(); ++index) {
                        Object item = fieldObjectList.get(index);
                        JsonElement itemJsonElement = fieldArrayValue.get(index);
                        this.addAdditionalDataFromJsonElementToJson(item, itemJsonElement);
                    }
                }
                this.addAdditionalDataFromJsonElementToJson(fieldObject, fieldJsonElement);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.logger.logError("Unable to access child fields of " + serializableObject.getClass().getSimpleName(), e);
            }
        }
    }

    private void addAdditionalDataFromJsonElementToJson(Object item, JsonElement itemJsonElement) {
        if (item instanceof IJsonBackedObject && itemJsonElement.isJsonObject()) {
            JsonObject itemJsonObject = itemJsonElement.getAsJsonObject();
            IJsonBackedObject serializableItem = (IJsonBackedObject)item;
            AdditionalDataManager itemAdditionalData = serializableItem.additionalDataManager();
            this.addAdditionalDataFromManagerToJson(itemAdditionalData, itemJsonObject);
            this.getChildAdditionalData(serializableItem, itemJsonObject);
        }
    }

    private void addAdditionalDataFromManagerToJson(AdditionalDataManager additionalDataManager, JsonObject jsonNode) {
        for (Map.Entry entry : additionalDataManager.entrySet()) {
            if (((String)entry.getKey()).equals(graphResponseHeadersKey)) continue;
            jsonNode.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    public Class<?> getDerivedClass(JsonObject jsonObject, Class<?> parentClass) {
        if (jsonObject.get(ODATA_TYPE_KEY) != null) {
            String odataType = jsonObject.get(ODATA_TYPE_KEY).getAsString();
            Integer lastDotIndex = odataType.lastIndexOf(".");
            String derivedType = (odataType.substring(0, lastDotIndex) + ".models.extensions." + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, odataType.substring(lastDotIndex + 1))).replace("#", "com.");
            try {
                Class<?> derivedClass = Class.forName(derivedType);
                if (parentClass.isAssignableFrom(derivedClass)) {
                    return derivedClass;
                }
                return null;
            }
            catch (ClassNotFoundException e) {
                this.logger.logDebug("Unable to find a corresponding class for derived type " + derivedType + ". Falling back to parent class.");
                return null;
            }
        }
        return null;
    }

    @VisibleForTesting
    public ILogger getLogger() {
        return this.logger;
    }
}

