/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SectionGroup;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISectionGroupCollectionPage;
import com.microsoft.graph.requests.extensions.ISectionGroupCollectionRequest;
import com.microsoft.graph.requests.extensions.SectionGroupCollectionPage;
import com.microsoft.graph.requests.extensions.SectionGroupCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SectionGroupCollectionResponse;
import com.microsoft.graph.requests.extensions.SectionGroupRequestBuilder;
import java.util.List;

public class SectionGroupCollectionRequest
extends BaseCollectionRequest<SectionGroupCollectionResponse, ISectionGroupCollectionPage>
implements ISectionGroupCollectionRequest {
    public SectionGroupCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SectionGroupCollectionResponse.class, ISectionGroupCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ISectionGroupCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SectionGroupCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISectionGroupCollectionPage get() throws ClientException {
        SectionGroupCollectionResponse response = (SectionGroupCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SectionGroup newSectionGroup, ICallback<? super SectionGroup> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SectionGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSectionGroup, callback);
    }

    @Override
    public SectionGroup post(SectionGroup newSectionGroup) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SectionGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSectionGroup);
    }

    @Override
    public ISectionGroupCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISectionGroupCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ISectionGroupCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ISectionGroupCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISectionGroupCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISectionGroupCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISectionGroupCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISectionGroupCollectionPage buildFromResponse(SectionGroupCollectionResponse response) {
        SectionGroupCollectionRequestBuilder builder = response.nextLink != null ? new SectionGroupCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SectionGroupCollectionPage page = new SectionGroupCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

