/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.content;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class MSBatchResponseContent {
    private final Response batchResponse;
    private LinkedHashMap<String, Request> batchRequestsHashMap;
    private JsonArray batchResponseArray;
    private String nextLink;

    public MSBatchResponseContent(Response batchResponse) {
        this.batchResponse = batchResponse;
        this.update(batchResponse);
    }

    public Response getResponseById(String requestId) {
        if (this.batchResponseArray == null) {
            return null;
        }
        JsonArray responses = this.batchResponseArray;
        for (JsonElement response : responses) {
            JsonElement jsonheadersElement;
            JsonElement jsonBodyElement;
            String id;
            JsonObject jsonresponse;
            JsonElement idElement;
            if (!response.isJsonObject() || (idElement = (jsonresponse = response.getAsJsonObject()).get("id")) == null || !idElement.isJsonPrimitive() || (id = idElement.getAsString()).compareTo(requestId) != 0) continue;
            Response.Builder builder = new Response.Builder();
            builder.request(this.batchRequestsHashMap.get(requestId));
            builder.protocol(this.batchResponse.protocol());
            builder.message(this.batchResponse.message());
            JsonElement statusElement = jsonresponse.get("status");
            if (statusElement != null && statusElement.isJsonPrimitive()) {
                Long status = statusElement.getAsLong();
                builder.code(status.intValue());
            }
            if ((jsonBodyElement = jsonresponse.get("body")) != null && jsonBodyElement.isJsonObject()) {
                JsonObject JsonObject2 = jsonBodyElement.getAsJsonObject();
                String bodyAsString = JsonObject2.toString();
                ResponseBody responseBody = ResponseBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)bodyAsString);
                builder.body(responseBody);
            }
            if ((jsonheadersElement = jsonresponse.get("headers")) != null && jsonheadersElement.isJsonObject()) {
                JsonObject jsonheaders = jsonheadersElement.getAsJsonObject();
                for (String key : jsonheaders.keySet()) {
                    JsonElement strValueElement = jsonheaders.get(key);
                    if (strValueElement == null || !strValueElement.isJsonPrimitive()) continue;
                    String strvalue = strValueElement.getAsString();
                    for (String value : strvalue.split(";")) {
                        builder.header(key, value);
                    }
                }
            }
            return builder.build();
        }
        return null;
    }

    public Map<String, Response> getResponses() {
        if (this.batchResponseArray == null) {
            return null;
        }
        LinkedHashMap<String, Response> responsesMap = new LinkedHashMap<String, Response>();
        for (String id : this.batchRequestsHashMap.keySet()) {
            responsesMap.put(id, this.getResponseById(id));
        }
        return responsesMap;
    }

    public Iterator<Map.Entry<String, Response>> getResponsesIterator() {
        Map<String, Response> responsesMap = this.getResponses();
        return responsesMap != null ? responsesMap.entrySet().iterator() : null;
    }

    public void update(Response batchResponse) {
        if (batchResponse == null) {
            throw new IllegalArgumentException("Batch Response cannot be null");
        }
        Map<String, Request> requestMap = this.createBatchRequestsHashMap(batchResponse);
        if (this.batchRequestsHashMap == null) {
            this.batchRequestsHashMap = new LinkedHashMap();
        }
        if (requestMap != null) {
            this.batchRequestsHashMap.putAll(requestMap);
        }
        if (batchResponse.body() != null) {
            try {
                JsonObject batchResponseObj;
                String batchResponseData = batchResponse.body().string();
                if (batchResponseData != null && (batchResponseObj = this.stringToJSONObject(batchResponseData)) != null) {
                    JsonElement responseArrayElement;
                    JsonElement nextLinkElement = batchResponseObj.get("@odata.nextLink");
                    if (nextLinkElement != null && nextLinkElement.isJsonPrimitive()) {
                        this.nextLink = nextLinkElement.getAsString();
                    }
                    if (this.batchResponseArray == null) {
                        this.batchResponseArray = new JsonArray();
                    }
                    if ((responseArrayElement = batchResponseObj.get("responses")) != null && responseArrayElement.isJsonArray()) {
                        JsonArray responseArray = responseArrayElement.getAsJsonArray();
                        this.batchResponseArray.addAll(responseArray);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String nextLink() {
        return this.nextLink;
    }

    private Map<String, Request> createBatchRequestsHashMap(Response batchResponse) {
        if (batchResponse == null) {
            return null;
        }
        try {
            LinkedHashMap<String, Request> batchRequestsHashMap = new LinkedHashMap<String, Request>();
            JsonObject requestJSONObject = this.requestBodyToJSONObject(batchResponse.request());
            JsonElement requestArrayElement = requestJSONObject.get("requests");
            if (requestArrayElement != null && requestArrayElement.isJsonArray()) {
                JsonArray requestArray = requestArrayElement.getAsJsonArray();
                for (JsonElement item : requestArray) {
                    JsonElement jsonIdElement;
                    JsonElement jsonHeadersElement;
                    if (!item.isJsonObject()) continue;
                    JsonObject requestObject = item.getAsJsonObject();
                    Request.Builder builder = new Request.Builder();
                    JsonElement urlElement = requestObject.get("url");
                    if (urlElement != null && urlElement.isJsonPrimitive()) {
                        StringBuilder fullUrl = new StringBuilder(batchResponse.request().url().toString().replace("$batch", ""));
                        fullUrl.append(urlElement.getAsString());
                        builder.url(fullUrl.toString());
                    }
                    if ((jsonHeadersElement = requestObject.get("headers")) != null && jsonHeadersElement.isJsonObject()) {
                        JsonObject jsonheaders = jsonHeadersElement.getAsJsonObject();
                        for (String key : jsonheaders.keySet()) {
                            JsonElement strvalueElement = jsonheaders.get(key);
                            if (strvalueElement == null || !strvalueElement.isJsonPrimitive()) continue;
                            String strvalue = strvalueElement.getAsString();
                            for (String value : strvalue.split("; ")) {
                                builder.header(key, value);
                            }
                        }
                    }
                    JsonElement jsonBodyElement = requestObject.get("body");
                    JsonElement jsonMethodElement = requestObject.get("method");
                    if (jsonBodyElement != null && jsonMethodElement != null && jsonBodyElement.isJsonObject() && jsonMethodElement.isJsonPrimitive()) {
                        JsonObject JsonObject2 = jsonBodyElement.getAsJsonObject();
                        String bodyAsString = JsonObject2.toString();
                        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)bodyAsString);
                        builder.method(jsonMethodElement.getAsString(), requestBody);
                    } else if (jsonMethodElement != null) {
                        builder.method(jsonMethodElement.getAsString(), null);
                    }
                    if ((jsonIdElement = requestObject.get("id")) == null || !jsonIdElement.isJsonPrimitive()) continue;
                    batchRequestsHashMap.put(jsonIdElement.getAsString(), builder.build());
                }
            }
            return batchRequestsHashMap;
        }
        catch (JsonParseException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private JsonObject stringToJSONObject(String input) {
        JsonObject JsonObject2 = null;
        try {
            if (input != null) {
                JsonObject2 = JsonParser.parseString((String)input).getAsJsonObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return JsonObject2;
    }

    private JsonObject requestBodyToJSONObject(Request request) throws IOException, JsonParseException {
        if (request == null || request.body() == null) {
            return null;
        }
        Request copy = request.newBuilder().build();
        Buffer buffer = new Buffer();
        copy.body().writeTo((BufferedSink)buffer);
        String requestBody = buffer.readUtf8();
        JsonObject JsonObject2 = JsonParser.parseString((String)requestBody).getAsJsonObject();
        return JsonObject2;
    }
}

