/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.msgraph;

import com.google.api.client.auth.oauth2.Credential;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.models.extensions.Permission;
import com.microsoft.graph.options.Option;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.apps.AppLink;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.msgraph.MSGraphDriveItemLiveConnectFile;
import org.nuxeo.ecm.liveconnect.msgraph.MSGraphOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class MSGraphBlobProvider
extends AbstractLiveConnectBlobProvider<MSGraphOAuth2ServiceProvider> {
    private static final Log log = LogFactory.getLog(MSGraphBlobProvider.class);
    private static final String CACHE_NAME = "msgraph";
    private static final String ONEDRIVE_DOCUMENT_TO_BE_UPDATED_PP = "onedrive_document_to_be_updated";

    protected String getCacheName() {
        return CACHE_NAME;
    }

    protected String getPageProviderNameForUpdate() {
        return ONEDRIVE_DOCUMENT_TO_BE_UPDATED_PP;
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint usage, HttpServletRequest servletRequest) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        String url = null;
        switch (usage) {
            case STREAM: 
            case DOWNLOAD: {
                url = this.GetDriveItem((LiveConnectFileInfo)fileInfo).webUrl;
                break;
            }
            case VIEW: 
            case EDIT: {
                url = this.getSharableLink(fileInfo);
            }
        }
        return url == null ? null : this.asURI(url);
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        IGraphServiceClient graphServiceClient = this.getGraphClient(fileInfo);
        return graphServiceClient.me().drive().items(fileInfo.getFileId()).content().buildRequest(new Option[0]).get();
    }

    public InputStream getThumbnail(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        IGraphServiceClient graphServiceClient = this.getGraphClient(fileInfo);
        return graphServiceClient.me().drive().items(fileInfo.getFileId()).thumbnails("0").getThumbnailSize("large").content().buildRequest(new Option[0]).get();
    }

    public List<AppLink> getAppLinks(String username, ManagedBlob blob) throws IOException {
        if (!blob.getMimeType().contains("officedocument")) {
            return Collections.emptyList();
        }
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        if (fileInfo.getRevisionId().isPresent()) {
            return Collections.emptyList();
        }
        String baseUrl = Framework.getProperty((String)"nuxeo.url", (String)VirtualHostHelper.getContextPathProperty());
        AppLink appLink = new AppLink();
        String appUrl = this.getSharableLink(fileInfo);
        appLink.setLink(appUrl);
        appLink.setAppName("Microsoft OneDrive");
        appLink.setIcon(baseUrl + "/icons/OneDrive.png");
        return Collections.singletonList(appLink);
    }

    protected IGraphServiceClient getGraphClient(LiveConnectFileInfo fileInfo) throws IOException {
        return this.getGraphClient(this.getCredential(fileInfo));
    }

    protected IGraphServiceClient getGraphClient(Credential credential) {
        return ((MSGraphOAuth2ServiceProvider)this.getOAuth2Provider()).getGraphClient(credential);
    }

    protected LiveConnectFile retrieveFile(LiveConnectFileInfo fileInfo) throws IOException {
        return new MSGraphDriveItemLiveConnectFile(fileInfo, this.retrieveOneDriveFileMetadata(fileInfo));
    }

    protected DriveItem retrieveOneDriveFileMetadata(LiveConnectFileInfo fileInfo) throws IOException {
        return this.GetDriveItem(fileInfo);
    }

    protected DriveItem GetDriveItem(LiveConnectFileInfo fileInfo) throws IOException {
        IGraphServiceClient graphClient = this.getGraphClient(fileInfo);
        return graphClient.me().drive().items(fileInfo.getFileId()).buildRequest(new Option[0]).get();
    }

    protected String getSharableLink(LiveConnectFileInfo fileInfo) throws IOException {
        IGraphServiceClient graphClient = this.getGraphClient(fileInfo);
        Permission permission = graphClient.me().drive().items(fileInfo.getFileId()).createLink("edit", "anonymous", null, null, null).buildRequest(new Option[0]).post();
        return permission.link.webUrl;
    }
}

