/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.msgraph;

import com.google.api.client.auth.oauth2.Credential;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.models.extensions.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.GraphServiceClient;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectOAuth2ServiceProvider;

public class MSGraphOAuth2ServiceProvider
extends AbstractLiveConnectOAuth2ServiceProvider {
    private static final Log log = LogFactory.getLog(MSGraphOAuth2ServiceProvider.class);

    protected IGraphServiceClient getGraphClient(Credential credential) {
        String accessToken = credential.getAccessToken();
        return this.getGraphClient(accessToken);
    }

    protected IGraphServiceClient getGraphClient(String accessToken) {
        return GraphServiceClient.builder().authenticationProvider(request -> request.addHeader("Authorization", "Bearer " + accessToken)).buildClient();
    }

    protected String getUserEmail(String accessToken) throws IOException {
        IGraphServiceClient graphClient = this.getGraphClient(accessToken);
        User user = graphClient.me().buildRequest(new Option[0]).get();
        return user.userPrincipalName;
    }
}

