/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class HttpLogOptions {
    private String applicationId = null;
    private HttpLogDetailLevel logLevel;
    private Set<String> allowedHeaderNames;
    private Set<String> allowedQueryParamNames;
    private boolean prettyPrintBody;
    private final ClientLogger logger = new ClientLogger(HttpLogOptions.class);
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private static final List<String> DEFAULT_HEADERS_WHITELIST = Arrays.asList("x-ms-client-request-id", "x-ms-return-client-request-id", "traceparent", "Accept", "Cache-Control", "Connection", "Content-Length", "Content-Type", "Date", "ETag", "Expires", "If-Match", "If-Modified-Since", "If-None-Match", "If-Unmodified-Since", "Last-Modified", "Pragma", "Request-Id", "Retry-After", "Server", "Transfer-Encoding", "User-Agent");

    public HttpLogOptions() {
        this.logLevel = HttpLogDetailLevel.ENVIRONMENT_HTTP_LOG_DETAIL_LEVEL;
        this.allowedHeaderNames = new HashSet<String>(DEFAULT_HEADERS_WHITELIST);
        this.allowedQueryParamNames = new HashSet<String>();
    }

    public HttpLogDetailLevel getLogLevel() {
        return this.logLevel;
    }

    public HttpLogOptions setLogLevel(HttpLogDetailLevel logLevel) {
        this.logLevel = logLevel == null ? HttpLogDetailLevel.NONE : logLevel;
        return this;
    }

    public Set<String> getAllowedHeaderNames() {
        return this.allowedHeaderNames;
    }

    public HttpLogOptions setAllowedHeaderNames(Set<String> allowedHeaderNames) {
        this.allowedHeaderNames = allowedHeaderNames == null ? new HashSet() : allowedHeaderNames;
        return this;
    }

    public HttpLogOptions addAllowedHeaderName(String allowedHeaderName) {
        Objects.requireNonNull(allowedHeaderName);
        this.allowedHeaderNames.add(allowedHeaderName);
        return this;
    }

    public Set<String> getAllowedQueryParamNames() {
        return this.allowedQueryParamNames;
    }

    public HttpLogOptions setAllowedQueryParamNames(Set<String> allowedQueryParamNames) {
        this.allowedQueryParamNames = allowedQueryParamNames == null ? new HashSet() : allowedQueryParamNames;
        return this;
    }

    public HttpLogOptions addAllowedQueryParamName(String allowedQueryParamName) {
        this.allowedQueryParamNames.add(allowedQueryParamName);
        return this;
    }

    @Deprecated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Deprecated
    public HttpLogOptions setApplicationId(String applicationId) {
        if (!CoreUtils.isNullOrEmpty(applicationId)) {
            if (applicationId.length() > 24) {
                throw this.logger.logExceptionAsError(new IllegalArgumentException("'applicationId' length cannot be greater than 24"));
            }
            if (applicationId.contains(" ")) {
                throw this.logger.logExceptionAsError(new IllegalArgumentException("'applicationId' must not contain a space."));
            }
            this.applicationId = applicationId;
        }
        return this;
    }

    public boolean isPrettyPrintBody() {
        return this.prettyPrintBody;
    }

    public HttpLogOptions setPrettyPrintBody(boolean prettyPrintBody) {
        this.prettyPrintBody = prettyPrintBody;
        return this;
    }
}

