/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.UrlToken;
import com.azure.core.util.UrlTokenType;
import com.azure.core.util.UrlTokenizer;
import com.azure.core.util.UrlTokenizerState;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class UrlBuilder {
    private static final Map<String, UrlBuilder> PARSED_URLS = new ConcurrentHashMap<String, UrlBuilder>();
    private static final int MAX_CACHE_SIZE = 10000;
    private String scheme;
    private String host;
    private String port;
    private String path;
    private final Map<String, String> query = new LinkedHashMap<String, String>();

    public UrlBuilder setScheme(String scheme) {
        if (scheme == null || scheme.isEmpty()) {
            this.scheme = null;
        } else {
            this.with(scheme, UrlTokenizerState.SCHEME);
        }
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public UrlBuilder setHost(String host) {
        if (host == null || host.isEmpty()) {
            this.host = null;
        } else {
            this.with(host, UrlTokenizerState.SCHEME_OR_HOST);
        }
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public UrlBuilder setPort(String port) {
        if (port == null || port.isEmpty()) {
            this.port = null;
        } else {
            this.with(port, UrlTokenizerState.PORT);
        }
        return this;
    }

    public UrlBuilder setPort(int port) {
        return this.setPort(Integer.toString(port));
    }

    public Integer getPort() {
        return this.port == null ? null : Integer.valueOf(this.port);
    }

    public UrlBuilder setPath(String path) {
        if (path == null || path.isEmpty()) {
            this.path = null;
        } else {
            this.with(path, UrlTokenizerState.PATH);
        }
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public UrlBuilder setQueryParameter(String queryParameterName, String queryParameterEncodedValue) {
        this.query.put(queryParameterName, queryParameterEncodedValue);
        return this;
    }

    public UrlBuilder setQuery(String query) {
        if (query == null || query.isEmpty()) {
            this.query.clear();
        } else {
            this.with(query, UrlTokenizerState.QUERY);
        }
        return this;
    }

    public Map<String, String> getQuery() {
        return this.query;
    }

    public String getQueryString() {
        if (this.query.isEmpty()) {
            return "";
        }
        StringBuilder queryBuilder = new StringBuilder("?");
        for (Map.Entry<String, String> entry : this.query.entrySet()) {
            if (queryBuilder.length() > 1) {
                queryBuilder.append("&");
            }
            queryBuilder.append(entry.getKey());
            queryBuilder.append("=");
            queryBuilder.append(entry.getValue());
        }
        return queryBuilder.toString();
    }

    private UrlBuilder with(String text, UrlTokenizerState startState) {
        UrlTokenizer tokenizer = new UrlTokenizer(text, startState);
        block7: while (tokenizer.next()) {
            UrlToken token = tokenizer.current();
            String tokenText = token.text();
            UrlTokenType tokenType = token.type();
            switch (tokenType) {
                case SCHEME: {
                    this.scheme = UrlBuilder.emptyToNull(tokenText);
                    break;
                }
                case HOST: {
                    this.host = UrlBuilder.emptyToNull(tokenText);
                    break;
                }
                case PORT: {
                    this.port = UrlBuilder.emptyToNull(tokenText);
                    break;
                }
                case PATH: {
                    String tokenPath = UrlBuilder.emptyToNull(tokenText);
                    if (this.path != null && !this.path.equals("/") && tokenPath.equals("/")) break;
                    this.path = tokenPath;
                    break;
                }
                case QUERY: {
                    String queryString = UrlBuilder.emptyToNull(tokenText);
                    if (queryString == null) break;
                    if (queryString.startsWith("?")) {
                        queryString = queryString.substring(1);
                    }
                    for (String entry : queryString.split("&")) {
                        String[] nameValue = entry.split("=");
                        if (nameValue.length == 2) {
                            this.setQueryParameter(nameValue[0], nameValue[1]);
                            continue;
                        }
                        this.setQueryParameter(nameValue[0], "");
                    }
                    continue block7;
                }
            }
        }
        return this;
    }

    public URL toUrl() throws MalformedURLException {
        return new URL(this.toString());
    }

    public String toString() {
        boolean isAbsolutePath;
        StringBuilder result = new StringBuilder();
        boolean bl = isAbsolutePath = this.path != null && (this.path.startsWith("http://") || this.path.startsWith("https://"));
        if (!isAbsolutePath) {
            if (this.scheme != null) {
                result.append(this.scheme);
                if (!this.scheme.endsWith("://")) {
                    result.append("://");
                }
            }
            if (this.host != null) {
                result.append(this.host);
            }
        }
        if (this.port != null) {
            result.append(":");
            result.append(this.port);
        }
        if (this.path != null) {
            if (result.length() != 0 && !this.path.startsWith("/")) {
                result.append('/');
            }
            result.append(this.path);
        }
        result.append(this.getQueryString());
        return result.toString();
    }

    static Map<String, UrlBuilder> getParsedUrls() {
        return PARSED_URLS;
    }

    public static UrlBuilder parse(String url) {
        String concurrentSafeUrl;
        String string = concurrentSafeUrl = url == null ? "" : url;
        if (PARSED_URLS.size() >= 10000) {
            PARSED_URLS.clear();
        }
        return PARSED_URLS.computeIfAbsent(concurrentSafeUrl, u -> new UrlBuilder().with((String)u, UrlTokenizerState.SCHEME_OR_HOST)).copy();
    }

    public static UrlBuilder parse(URL url) {
        UrlBuilder result = new UrlBuilder();
        if (url != null) {
            String query;
            String path;
            int port;
            String host;
            String protocol = url.getProtocol();
            if (protocol != null && !protocol.isEmpty()) {
                result.setScheme(protocol);
            }
            if ((host = url.getHost()) != null && !host.isEmpty()) {
                result.setHost(host);
            }
            if ((port = url.getPort()) != -1) {
                result.setPort(port);
            }
            if ((path = url.getPath()) != null && !path.isEmpty()) {
                result.setPath(path);
            }
            if ((query = url.getQuery()) != null && !query.isEmpty()) {
                result.setQuery(query);
            }
        }
        return result;
    }

    private static String emptyToNull(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    private UrlBuilder copy() {
        UrlBuilder copy = new UrlBuilder();
        copy.scheme = this.scheme;
        copy.host = this.host;
        copy.path = this.path;
        copy.port = this.port;
        copy.query.putAll(this.query);
        return copy;
    }
}

