/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.msgraph;

import com.google.api.client.auth.oauth2.Credential;
import com.google.gson.JsonElement;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.DriveItemCreateLinkParameterSet;
import com.microsoft.graph.models.DriveItemPreviewParameterSet;
import com.microsoft.graph.models.ItemPreviewInfo;
import com.microsoft.graph.models.Permission;
import com.microsoft.graph.models.ThumbnailSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.ThumbnailSetCollectionPage;
import com.microsoft.graph.requests.ThumbnailSetCollectionRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import okhttp3.Request;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.apps.AppLink;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.msgraph.MSGraphDriveItemLiveConnectFile;
import org.nuxeo.ecm.liveconnect.msgraph.MSGraphOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class MSGraphBlobProvider
extends AbstractLiveConnectBlobProvider<MSGraphOAuth2ServiceProvider> {
    private static final Log log = LogFactory.getLog(MSGraphBlobProvider.class);
    private static final String CACHE_NAME = "msgraph";
    private static final String ONEDRIVE_DOCUMENT_TO_BE_UPDATED_PP = "msgraph_document_to_be_updated";

    protected String getCacheName() {
        return CACHE_NAME;
    }

    protected String getPageProviderNameForUpdate() {
        return ONEDRIVE_DOCUMENT_TO_BE_UPDATED_PP;
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint usage, HttpServletRequest servletRequest) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        String url = null;
        switch (usage) {
            case STREAM: 
            case DOWNLOAD: {
                url = this.getDownloadUrl(fileInfo);
                break;
            }
            case VIEW: {
                url = this.getSharableLink(fileInfo, "view");
                break;
            }
            case EDIT: {
                url = this.getSharableLink(fileInfo, "edit");
                break;
            }
            case EMBED: {
                url = this.getEmbedUrl(fileInfo);
            }
        }
        return url == null ? null : this.asURI(url);
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        GraphServiceClient<Request> graphServiceClient = this.getGraphClient(fileInfo);
        return graphServiceClient.me().drive().items(fileInfo.getFileId()).content().buildRequest(new Option[0]).get();
    }

    public InputStream getThumbnail(ManagedBlob blob) throws IOException {
        String size;
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        GraphServiceClient<Request> graphServiceClient = this.getGraphClient(fileInfo);
        ThumbnailSetCollectionPage thumbnailSetPage = (ThumbnailSetCollectionPage)((ThumbnailSetCollectionRequest)graphServiceClient.me().drive().items(fileInfo.getFileId()).thumbnails().buildRequest(new Option[0])).get();
        if (thumbnailSetPage == null) {
            return null;
        }
        List thumbnailSets = thumbnailSetPage.getCurrentPage();
        if (thumbnailSets.isEmpty()) {
            return null;
        }
        ThumbnailSet thumbnailSet = (ThumbnailSet)thumbnailSets.get(0);
        if (thumbnailSet.large != null) {
            size = "large";
        } else if (thumbnailSet.medium != null) {
            size = "medium";
        } else if (thumbnailSet.small != null) {
            size = "small";
        } else {
            return null;
        }
        return graphServiceClient.me().drive().items(fileInfo.getFileId()).thumbnails("0").getThumbnailSize(size).content().buildRequest(new Option[0]).get();
    }

    public List<AppLink> getAppLinks(String username, ManagedBlob blob) throws IOException {
        if (!blob.getMimeType().contains("officedocument")) {
            return Collections.emptyList();
        }
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        if (fileInfo.getRevisionId().isPresent()) {
            return Collections.emptyList();
        }
        String baseUrl = Framework.getProperty((String)"nuxeo.url", (String)VirtualHostHelper.getContextPathProperty());
        AppLink appLink = new AppLink();
        String appUrl = this.getSharableLink(fileInfo, "edit");
        appLink.setLink(appUrl);
        appLink.setAppName("Microsoft OneDrive");
        appLink.setIcon(baseUrl + "/icons/OneDrive.png");
        return Collections.singletonList(appLink);
    }

    protected GraphServiceClient<Request> getGraphClient(LiveConnectFileInfo fileInfo) throws IOException {
        return this.getGraphClient(this.getCredential(fileInfo));
    }

    protected GraphServiceClient<Request> getGraphClient(Credential credential) {
        return ((MSGraphOAuth2ServiceProvider)this.getOAuth2Provider()).getGraphClient(credential);
    }

    protected LiveConnectFile retrieveFile(LiveConnectFileInfo fileInfo) throws IOException {
        return new MSGraphDriveItemLiveConnectFile(fileInfo, this.retrieveOneDriveFileMetadata(fileInfo));
    }

    protected DriveItem retrieveOneDriveFileMetadata(LiveConnectFileInfo fileInfo) throws IOException {
        return this.GetDriveItem(fileInfo);
    }

    protected DriveItem GetDriveItem(LiveConnectFileInfo fileInfo) throws IOException {
        GraphServiceClient<Request> graphClient = this.getGraphClient(fileInfo);
        return graphClient.me().drive().items(fileInfo.getFileId()).buildRequest(new Option[0]).get();
    }

    protected String getSharableLink(LiveConnectFileInfo fileInfo, String type) throws IOException {
        GraphServiceClient<Request> graphClient = this.getGraphClient(fileInfo);
        Permission permission = graphClient.me().drive().items(fileInfo.getFileId()).createLink(DriveItemCreateLinkParameterSet.newBuilder().withScope("anonymous").withType(type).build()).buildRequest(new Option[0]).post();
        return permission.link.webUrl;
    }

    protected String getEmbedUrl(LiveConnectFileInfo fileInfo) throws IOException {
        GraphServiceClient<Request> graphClient = this.getGraphClient(fileInfo);
        Drive drive = graphClient.me().drive().buildRequest(new Option[0]).get();
        if ("business".equals(drive.driveType)) {
            ItemPreviewInfo preview = graphClient.me().drive().items(fileInfo.getFileId()).preview(DriveItemPreviewParameterSet.newBuilder().build()).buildRequest(new Option[0]).post();
            return preview.getUrl;
        }
        return this.getSharableLink(fileInfo, "embed");
    }

    protected String getDownloadUrl(LiveConnectFileInfo fileInfo) throws IOException {
        GraphServiceClient<Request> graphClient = this.getGraphClient(fileInfo);
        DriveItem item = graphClient.me().drive().items(fileInfo.getFileId()).buildRequest(new Option[0]).get();
        JsonElement element = (JsonElement)item.additionalDataManager().get((Object)"@microsoft.graph.downloadUrl");
        return !element.isJsonNull() ? element.getAsString() : null;
    }
}

