/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SiteReferenceRequest
extends BaseReferenceRequest<Site> {
    public SiteReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Site.class);
    }

    @Nonnull
    public SiteReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SiteReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<Site> putAsync(@Nonnull Site srcSite) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/sites/" + srcSite.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public Site put(@Nonnull Site srcSite) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/sites/" + srcSite.id));
        return (Site)this.send(HttpMethod.PUT, payload);
    }
}

