/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.ICollectionResponse;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.httpcore.middlewareoption.IShouldRedirect;
import com.microsoft.graph.httpcore.middlewareoption.IShouldRetry;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseCollectionRequest<T, T2 extends ICollectionResponse<T>, T3 extends BaseCollectionPage<T, ? extends BaseRequestBuilder<T>>>
implements IHttpRequest {
    private final BaseRequest<T2> baseRequest;
    protected final Class<T2> responseCollectionClass;
    private final Class<T3> collectionPageClass;
    private final Class<? extends BaseCollectionRequestBuilder<T, ? extends BaseRequestBuilder<T>, T2, T3, ? extends BaseCollectionRequest<T, T2, T3>>> collRequestBuilderClass;

    public BaseCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> options, @Nonnull Class<T2> responseCollectionClass, @Nonnull Class<T3> collectionPageClass, @Nonnull Class<? extends BaseCollectionRequestBuilder<T, ? extends BaseRequestBuilder<T>, T2, T3, ? extends BaseCollectionRequest<T, T2, T3>>> collectionRequestBuilderClass) {
        this.responseCollectionClass = Objects.requireNonNull(responseCollectionClass, "parameter responseCollectionClass cannot be null");
        this.collectionPageClass = Objects.requireNonNull(collectionPageClass, "parameter collectionPageClass cannot be null");
        this.collRequestBuilderClass = Objects.requireNonNull(collectionRequestBuilderClass, "parameter collectionRequestBuilderClass cannot be null");
        this.baseRequest = new BaseRequest<T2>(requestUrl, client, options, responseCollectionClass){};
    }

    @Nullable
    protected T2 send() throws ClientException {
        this.baseRequest.setHttpMethod(HttpMethod.GET);
        return (T2)((ICollectionResponse)this.baseRequest.getClient().getHttpProvider().send(this, this.responseCollectionClass, null));
    }

    @Nullable
    protected CompletableFuture<T2> sendAsync() throws ClientException {
        this.baseRequest.setHttpMethod(HttpMethod.GET);
        return this.baseRequest.getClient().getHttpProvider().sendAsync(this, this.responseCollectionClass, null);
    }

    @Nullable
    public T3 buildFromResponse(@Nonnull T2 response) {
        Objects.requireNonNull(response, "parameter response cannot be null");
        try {
            BaseCollectionRequestBuilder<T, BaseRequestBuilder<T>, ? extends BaseRequestBuilder<T>, T2, BaseCollectionRequest<T, ? extends BaseRequestBuilder<T>, T2>> builder = response.nextLink() == null ? null : this.collRequestBuilderClass.getConstructor(String.class, IBaseClient.class, List.class).newInstance(response.nextLink(), this.getBaseRequest().getClient(), Collections.emptyList());
            BaseCollectionPage page = (BaseCollectionPage)this.collectionPageClass.getConstructor(response.getClass(), this.collRequestBuilderClass).newInstance(response, builder);
            return (T3)page;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ClientException("Could not find the required class", ex);
        }
    }

    @Override
    @Nonnull
    public URL getRequestUrl() {
        return this.baseRequest.getRequestUrl();
    }

    @Override
    @Nullable
    public HttpMethod getHttpMethod() {
        return this.baseRequest.getHttpMethod();
    }

    @Override
    @Nullable
    public List<HeaderOption> getHeaders() {
        return this.baseRequest.getHeaders();
    }

    @Override
    public void addHeader(@Nonnull String header, @Nullable String value) {
        Objects.requireNonNull(header, "parameter header cannot be null");
        this.baseRequest.addHeader(header, value);
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.baseRequest.setUseCaches(useCaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.baseRequest.getUseCaches();
    }

    @Override
    @Nullable
    public List<Option> getOptions() {
        return this.baseRequest.getOptions();
    }

    public void addQueryOption(@Nonnull QueryOption option) {
        Objects.requireNonNull(option, "parameter option cannot be null");
        this.baseRequest.getQueryOptions().add(option);
    }

    protected void addExpandOption(@Nonnull String value) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        this.addQueryOption(new QueryOption("$expand", value));
    }

    protected void addFilterOption(@Nonnull String value) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        this.addQueryOption(new QueryOption("$filter", value));
    }

    protected void addOrderByOption(@Nonnull String value) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        this.addQueryOption(new QueryOption("$orderby", value));
    }

    protected void addSelectOption(@Nonnull String value) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        this.addQueryOption(new QueryOption("$select", value));
    }

    protected void addTopOption(int value) {
        this.addQueryOption(new QueryOption("$top", String.valueOf(value)));
    }

    protected void addSkipOption(int value) {
        this.addQueryOption(new QueryOption("$skip", String.valueOf(value)));
    }

    protected void addSkipTokenOption(@Nonnull String skipToken) {
        Objects.requireNonNull(skipToken, "parameter skipToken cannot be null");
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
    }

    protected void addCountOption(boolean value) {
        this.addQueryOption(new QueryOption("$count", String.valueOf(value)));
    }

    public void addFunctionOption(@Nonnull FunctionOption option) {
        Objects.requireNonNull(option, "parameter option cannot be null");
        this.baseRequest.getFunctionOptions().add(option);
    }

    @Nonnull
    public BaseRequest<T2> getBaseRequest() {
        return this.baseRequest;
    }

    @Nonnull
    public Class<T3> getCollectionPageClass() {
        return this.collectionPageClass;
    }

    @Override
    public void setMaxRedirects(int maxRedirects) {
        this.baseRequest.setMaxRedirects(maxRedirects);
    }

    @Override
    public int getMaxRedirects() {
        return this.baseRequest.getMaxRedirects();
    }

    @Override
    public void setShouldRedirect(@Nonnull IShouldRedirect shouldRedirect) {
        Objects.requireNonNull(shouldRedirect, "parameter shouldRedirect cannot be null");
        this.baseRequest.setShouldRedirect(shouldRedirect);
    }

    @Override
    @Nonnull
    public IShouldRedirect getShouldRedirect() {
        return this.baseRequest.getShouldRedirect();
    }

    @Override
    public void setShouldRetry(@Nonnull IShouldRetry shouldretry) {
        Objects.requireNonNull(shouldretry, "parameter shouldretry cannot be null");
        this.baseRequest.setShouldRetry(shouldretry);
    }

    @Override
    @Nonnull
    public IShouldRetry getShouldRetry() {
        return this.baseRequest.getShouldRetry();
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        this.baseRequest.setMaxRetries(maxRetries);
    }

    @Override
    public int getMaxRetries() {
        return this.baseRequest.getMaxRetries();
    }

    @Override
    public void setDelay(long delay) {
        this.baseRequest.setDelay(delay);
    }

    @Override
    public long getDelay() {
        return this.baseRequest.getDelay();
    }

    @Override
    @Nullable
    public IHttpRequest withHttpMethod(@Nonnull HttpMethod httpMethod) {
        Objects.requireNonNull(httpMethod, "parameter httpMethod cannot be null");
        this.baseRequest.setHttpMethod(httpMethod);
        return this;
    }

    @Override
    @Nullable
    public <requestBodyType, responseType, nativeRequestType> nativeRequestType getHttpRequest(@Nullable requestBodyType serializedObject) throws ClientException {
        return this.baseRequest.getHttpRequest(serializedObject);
    }
}

