/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.identitygovernance.models.Run;
import com.microsoft.graph.identitygovernance.requests.RunCollectionPage;
import com.microsoft.graph.identitygovernance.requests.RunCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.RunCollectionResponse;
import com.microsoft.graph.identitygovernance.requests.RunRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RunCollectionRequest
extends BaseEntityCollectionRequest<Run, RunCollectionResponse, RunCollectionPage> {
    public RunCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RunCollectionResponse.class, RunCollectionPage.class, RunCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Run> postAsync(@Nonnull Run newRun) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RunRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newRun);
    }

    @Nonnull
    public Run post(@Nonnull Run newRun) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RunRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newRun);
    }

    @Nonnull
    public RunCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public RunCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public RunCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public RunCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public RunCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public RunCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public RunCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public RunCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public RunCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

