/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.List;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ListCollectionPage;
import com.microsoft.graph.requests.ListCollectionRequestBuilder;
import com.microsoft.graph.requests.ListCollectionResponse;
import com.microsoft.graph.requests.ListRequestBuilder;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListCollectionRequest
extends BaseEntityCollectionRequest<List, ListCollectionResponse, ListCollectionPage> {
    public ListCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ListCollectionResponse.class, ListCollectionPage.class, ListCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<List> postAsync(@Nonnull List newList) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ListRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newList);
    }

    @Nonnull
    public List post(@Nonnull List newList) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ListRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newList);
    }

    @Nonnull
    public ListCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ListCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ListCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ListCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ListCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ListCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ListCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ListCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ListCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

