/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore.middlewareoption;

import com.microsoft.graph.httpcore.middlewareoption.IMiddlewareControl;
import com.microsoft.graph.httpcore.middlewareoption.IShouldRedirect;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RedirectOptions
implements IMiddlewareControl {
    private int maxRedirects;
    public static final int DEFAULT_MAX_REDIRECTS = 5;
    public static final int MAX_REDIRECTS = 20;
    private IShouldRedirect shouldRedirect;
    public static final IShouldRedirect DEFAULT_SHOULD_REDIRECT = response -> true;

    public RedirectOptions() {
        this(5, DEFAULT_SHOULD_REDIRECT);
    }

    public RedirectOptions(int maxRedirects, @Nullable IShouldRedirect shouldRedirect) {
        if (maxRedirects < 0) {
            throw new IllegalArgumentException("Max redirects cannot be negative");
        }
        if (maxRedirects > 20) {
            throw new IllegalArgumentException("Max redirect cannot exceed 20");
        }
        this.maxRedirects = maxRedirects;
        this.shouldRedirect = shouldRedirect != null ? shouldRedirect : DEFAULT_SHOULD_REDIRECT;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    @Nonnull
    public IShouldRedirect shouldRedirect() {
        return this.shouldRedirect;
    }
}

