/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.identitygovernance.models.TaskProcessingResult;
import com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionPage;
import com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionResponse;
import com.microsoft.graph.identitygovernance.requests.TaskProcessingResultRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TaskProcessingResultCollectionRequest
extends BaseEntityCollectionRequest<TaskProcessingResult, TaskProcessingResultCollectionResponse, TaskProcessingResultCollectionPage> {
    public TaskProcessingResultCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TaskProcessingResultCollectionResponse.class, TaskProcessingResultCollectionPage.class, TaskProcessingResultCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<TaskProcessingResult> postAsync(@Nonnull TaskProcessingResult newTaskProcessingResult) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TaskProcessingResultRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newTaskProcessingResult);
    }

    @Nonnull
    public TaskProcessingResult post(@Nonnull TaskProcessingResult newTaskProcessingResult) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TaskProcessingResultRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTaskProcessingResult);
    }

    @Nonnull
    public TaskProcessingResultCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public TaskProcessingResultCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public TaskProcessingResultCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public TaskProcessingResultCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public TaskProcessingResultCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public TaskProcessingResultCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public TaskProcessingResultCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public TaskProcessingResultCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public TaskProcessingResultCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

