/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.gson.JsonObject;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomRequest<T>
extends BaseRequest<T> {
    public CustomRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull Class<T> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    @Nonnull
    public static CustomRequest<JsonObject> create(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        return new CustomRequest<JsonObject>(requestUrl, client, (List<Option>)requestOptions, JsonObject.class);
    }

    @Nullable
    public T get() throws ClientException {
        return this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<T> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<T> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<T> patchAsync() {
        return this.sendAsync(HttpMethod.PATCH, super.getResponseType());
    }

    @Nullable
    public T patch(@Nonnull T sourceObject) throws ClientException {
        Objects.requireNonNull(sourceObject, "parameter sourceObject cannot be null");
        return this.send(HttpMethod.PATCH, sourceObject);
    }

    @Nonnull
    public CompletableFuture<T> postAsync(@Nonnull T newObject) {
        Objects.requireNonNull(newObject, "parameter newObject cannot be null");
        return this.sendAsync(HttpMethod.POST, newObject);
    }

    @Nullable
    public T post(@Nonnull T newObject) throws ClientException {
        Objects.requireNonNull(newObject, "parameter newObject cannot be null");
        return this.send(HttpMethod.POST, newObject);
    }

    @Nonnull
    public CompletableFuture<T> putAsync(@Nonnull T putObject) {
        Objects.requireNonNull(putObject, "parameter putObject cannot be null");
        return this.sendAsync(HttpMethod.PUT, putObject);
    }

    @Nullable
    public T put(@Nonnull T putObject) throws ClientException {
        Objects.requireNonNull(putObject, "parameter putObject cannot be null");
        return this.send(HttpMethod.PUT, putObject);
    }

    @Nonnull
    public CustomRequest<T> select(@Nonnull String value) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Nonnull
    public CustomRequest<T> expand(@Nonnull String value) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

