/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.msgraph;

import com.azure.core.credential.AccessToken;
import com.google.api.client.auth.oauth2.Credential;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GraphServiceClient;
import okhttp3.Request;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectOAuth2ServiceProvider;
import reactor.core.publisher.Mono;

public class MSGraphOAuth2ServiceProvider
extends AbstractLiveConnectOAuth2ServiceProvider {
    private static final Log log = LogFactory.getLog(MSGraphOAuth2ServiceProvider.class);

    protected GraphServiceClient<Request> getGraphClient(Credential credential) {
        String accessToken = credential.getAccessToken();
        return this.getGraphClient(accessToken);
    }

    protected GraphServiceClient<Request> getGraphClient(String accessToken) {
        return GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)new TokenCredentialAuthProvider(this.getScopes(), tokenRequestContext -> Mono.just((Object)new AccessToken(accessToken, null)))).buildClient();
    }

    protected String getUserEmail(String accessToken) {
        GraphServiceClient<Request> graphClient = this.getGraphClient(accessToken);
        User user = graphClient.me().buildRequest(new Option[0]).get();
        return user.userPrincipalName;
    }
}

