/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.AuthenticationMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.AuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.AuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.AuthenticationMethodCollectionResponse;
import com.microsoft.graph.requests.AuthenticationMethodRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthenticationMethodCollectionRequest
extends BaseEntityCollectionRequest<AuthenticationMethod, AuthenticationMethodCollectionResponse, AuthenticationMethodCollectionPage> {
    public AuthenticationMethodCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethodCollectionResponse.class, AuthenticationMethodCollectionPage.class, AuthenticationMethodCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<AuthenticationMethod> postAsync(@Nonnull AuthenticationMethod newAuthenticationMethod) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AuthenticationMethodRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newAuthenticationMethod);
    }

    @Nonnull
    public AuthenticationMethod post(@Nonnull AuthenticationMethod newAuthenticationMethod) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AuthenticationMethodRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAuthenticationMethod);
    }

    @Nonnull
    public AuthenticationMethodCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public AuthenticationMethodCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public AuthenticationMethodCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public AuthenticationMethodCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AuthenticationMethodCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public AuthenticationMethodCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public AuthenticationMethodCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public AuthenticationMethodCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public AuthenticationMethodCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

