/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.AuthoredNote;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.AuthoredNoteCollectionPage;
import com.microsoft.graph.requests.AuthoredNoteCollectionRequestBuilder;
import com.microsoft.graph.requests.AuthoredNoteCollectionResponse;
import com.microsoft.graph.requests.AuthoredNoteRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthoredNoteCollectionRequest
extends BaseEntityCollectionRequest<AuthoredNote, AuthoredNoteCollectionResponse, AuthoredNoteCollectionPage> {
    public AuthoredNoteCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthoredNoteCollectionResponse.class, AuthoredNoteCollectionPage.class, AuthoredNoteCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<AuthoredNote> postAsync(@Nonnull AuthoredNote newAuthoredNote) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AuthoredNoteRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newAuthoredNote);
    }

    @Nonnull
    public AuthoredNote post(@Nonnull AuthoredNote newAuthoredNote) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AuthoredNoteRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAuthoredNote);
    }

    @Nonnull
    public AuthoredNoteCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public AuthoredNoteCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public AuthoredNoteCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public AuthoredNoteCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AuthoredNoteCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public AuthoredNoteCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public AuthoredNoteCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public AuthoredNoteCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public AuthoredNoteCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

