/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ExtensionProperty;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ExtensionPropertyCollectionPage;
import com.microsoft.graph.requests.ExtensionPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.ExtensionPropertyCollectionResponse;
import com.microsoft.graph.requests.ExtensionPropertyRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExtensionPropertyCollectionRequest
extends BaseEntityCollectionRequest<ExtensionProperty, ExtensionPropertyCollectionResponse, ExtensionPropertyCollectionPage> {
    public ExtensionPropertyCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ExtensionPropertyCollectionResponse.class, ExtensionPropertyCollectionPage.class, ExtensionPropertyCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ExtensionProperty> postAsync(@Nonnull ExtensionProperty newExtensionProperty) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ExtensionPropertyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newExtensionProperty);
    }

    @Nonnull
    public ExtensionProperty post(@Nonnull ExtensionProperty newExtensionProperty) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ExtensionPropertyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newExtensionProperty);
    }

    @Nonnull
    public ExtensionPropertyCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ExtensionPropertyCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ExtensionPropertyCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ExtensionPropertyCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ExtensionPropertyCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ExtensionPropertyCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ExtensionPropertyCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ExtensionPropertyCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ExtensionPropertyCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

