/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.SiteCollectionPage;
import com.microsoft.graph.requests.SiteCollectionRequestBuilder;
import com.microsoft.graph.requests.SiteCollectionResponse;
import com.microsoft.graph.requests.SiteRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SiteCollectionRequest
extends BaseEntityCollectionRequest<Site, SiteCollectionResponse, SiteCollectionPage> {
    public SiteCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteCollectionResponse.class, SiteCollectionPage.class, SiteCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Site> postAsync(@Nonnull Site newSite) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SiteRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSite);
    }

    @Nonnull
    public Site post(@Nonnull Site newSite) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SiteRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSite);
    }

    @Nonnull
    public SiteCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SiteCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SiteCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SiteCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SiteCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SiteCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SiteCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SiteCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SiteCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

