/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.msgraph;

import com.google.api.client.auth.oauth2.Credential;
import com.microsoft.graph.drives.item.items.item.DriveItemItemRequestBuilder;
import com.microsoft.graph.drives.item.items.item.createlink.CreateLinkPostRequestBody;
import com.microsoft.graph.drives.item.items.item.preview.PreviewPostRequestBody;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.ItemPreviewInfo;
import com.microsoft.graph.models.Permission;
import com.microsoft.graph.models.ThumbnailSet;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.apps.AppLink;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.msgraph.MSGraphDriveItemLiveConnectFile;
import org.nuxeo.ecm.liveconnect.msgraph.MSGraphOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class MSGraphBlobProvider
extends AbstractLiveConnectBlobProvider<MSGraphOAuth2ServiceProvider> {
    private static final Logger log = LogManager.getLogger(MSGraphBlobProvider.class);
    private static final String CACHE_NAME = "msgraph";
    private static final String ONEDRIVE_DOCUMENT_TO_BE_UPDATED_PP = "msgraph_document_to_be_updated";

    protected String getCacheName() {
        return CACHE_NAME;
    }

    protected String getPageProviderNameForUpdate() {
        return ONEDRIVE_DOCUMENT_TO_BE_UPDATED_PP;
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint usage, HttpServletRequest servletRequest) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        String url = null;
        switch (usage) {
            case STREAM: 
            case DOWNLOAD: {
                url = this.getDownloadUrl(fileInfo);
                break;
            }
            case VIEW: {
                url = this.getSharableLink(fileInfo, "view");
                break;
            }
            case EDIT: {
                url = this.getSharableLink(fileInfo, "edit");
                break;
            }
            case EMBED: {
                url = this.getEmbedUrl(fileInfo);
            }
        }
        return url == null ? null : this.asURI(url);
    }

    public InputStream getStream(ManagedBlob blob) {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        GraphServiceClient graphClient = this.getGraphClient(fileInfo);
        Drive drive = graphClient.me().drive().get();
        return this.getDriveItemRequestBuilder(fileInfo).content().get();
    }

    public InputStream getThumbnail(ManagedBlob blob) {
        byte[] content;
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        List thumbnailSets = this.getDriveItemRequestBuilder(fileInfo).thumbnails().get().getValue();
        if (thumbnailSets.isEmpty()) {
            return null;
        }
        ThumbnailSet thumbnailSet = (ThumbnailSet)thumbnailSets.get(0);
        if (thumbnailSet.getLarge() != null) {
            content = thumbnailSet.getLarge().getContent();
        } else if (thumbnailSet.getMedium() != null) {
            content = thumbnailSet.getMedium().getContent();
        } else if (thumbnailSet.getSmall() != null) {
            content = thumbnailSet.getSmall().getContent();
        } else {
            return null;
        }
        return content != null ? new ByteArrayInputStream(content) : null;
    }

    public List<AppLink> getAppLinks(String username, ManagedBlob blob) throws IOException {
        if (!blob.getMimeType().contains("officedocument")) {
            return Collections.emptyList();
        }
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        if (fileInfo.getRevisionId().isPresent()) {
            return Collections.emptyList();
        }
        String baseUrl = Framework.getProperty((String)"nuxeo.url", (String)VirtualHostHelper.getContextPathProperty());
        AppLink appLink = new AppLink();
        String appUrl = this.getSharableLink(fileInfo, "edit");
        appLink.setLink(appUrl);
        appLink.setAppName("Microsoft OneDrive");
        appLink.setIcon(baseUrl + "/icons/OneDrive.png");
        return Collections.singletonList(appLink);
    }

    protected LiveConnectFile retrieveFile(LiveConnectFileInfo fileInfo) throws IOException {
        return new MSGraphDriveItemLiveConnectFile(fileInfo, this.getDriveItem(fileInfo));
    }

    protected GraphServiceClient getGraphClient(LiveConnectFileInfo fileInfo) {
        try {
            return this.getGraphClient(this.getCredential(fileInfo));
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected GraphServiceClient getGraphClient(Credential credential) {
        return ((MSGraphOAuth2ServiceProvider)this.getOAuth2Provider()).getGraphClient(credential);
    }

    protected DriveItemItemRequestBuilder getDriveItemRequestBuilder(LiveConnectFileInfo fileInfo) {
        GraphServiceClient graphClient = this.getGraphClient(fileInfo);
        Drive drive = graphClient.me().drive().get();
        return graphClient.drives().byDriveId(drive.getId()).items().byDriveItemId(fileInfo.getFileId());
    }

    protected DriveItem getDriveItem(LiveConnectFileInfo fileInfo) throws IOException {
        return this.getDriveItemRequestBuilder(fileInfo).get();
    }

    protected String getSharableLink(LiveConnectFileInfo fileInfo, String type) throws IOException {
        CreateLinkPostRequestBody createLinkPostRequestBody = new CreateLinkPostRequestBody();
        createLinkPostRequestBody.setType(type);
        createLinkPostRequestBody.setScope("anonymous");
        createLinkPostRequestBody.setRetainInheritedPermissions(Boolean.valueOf(false));
        Permission permission = this.getDriveItemRequestBuilder(fileInfo).createLink().post(createLinkPostRequestBody);
        return permission.getLink().getWebUrl();
    }

    protected String getEmbedUrl(LiveConnectFileInfo fileInfo) throws IOException {
        GraphServiceClient graphClient = this.getGraphClient(fileInfo);
        Drive drive = graphClient.me().drive().get();
        if ("business".equals(drive.getDriveType())) {
            PreviewPostRequestBody previewPostRequestBody = new PreviewPostRequestBody();
            ItemPreviewInfo preview = this.getDriveItemRequestBuilder(fileInfo).preview().post(previewPostRequestBody);
            return preview.getGetUrl();
        }
        return this.getSharableLink(fileInfo, "embed");
    }

    protected String getDownloadUrl(LiveConnectFileInfo fileInfo) throws IOException {
        DriveItem item = this.getDriveItem(fileInfo);
        return (String)item.getAdditionalData().get("@microsoft.graph.downloadUrl");
    }
}

