/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.msgraph;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.microsoft.graph.models.User;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectOAuth2ServiceProvider;
import reactor.core.publisher.Mono;

public class MSGraphOAuth2ServiceProvider
extends AbstractLiveConnectOAuth2ServiceProvider {
    private static final Logger log = LogManager.getLogger(MSGraphOAuth2ServiceProvider.class);

    public Credential handleAuthorizationCallback(HttpServletRequest request) {
        String error = this.getError(request);
        if (error != null) {
            throw new NuxeoException("There was an error: \"" + error + "\".");
        }
        String code = this.getAuthorizationCode(request);
        if (code == null) {
            throw new NuxeoException("There is not code provided as QueryParam.");
        }
        try {
            AuthorizationCodeFlow flow = this.getAuthorizationCodeFlow();
            String redirectUri = this.getCallbackUrl(request);
            TokenResponse tokenResponse = flow.newTokenRequest(code).setScopes((Collection)(this.getScopes().isEmpty() ? null : this.getScopes())).setRedirectUri(redirectUri).set("client_id", (Object)this.getClientId()).set("client_secret", (Object)this.getClientSecret()).execute();
            String userId = this.getOrCreateServiceUser(request, tokenResponse.getAccessToken());
            return flow.createAndStoreCredential(tokenResponse, userId);
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to retrieve credential", (Throwable)e);
        }
    }

    protected String getUserEmail(String accessToken) {
        GraphServiceClient graphClient = this.getGraphClient(accessToken);
        User user = graphClient.me().get();
        return user.getMail();
    }

    protected GraphServiceClient getGraphClient(Credential credential) {
        String accessToken = credential.getAccessToken();
        return this.getGraphClient(accessToken);
    }

    protected GraphServiceClient getGraphClient(String accessToken) {
        TokenCredential tokenCredential = tokenRequestContext -> Mono.just((Object)new AccessToken(accessToken, null));
        return new GraphServiceClient(tokenCredential, (String[])this.getScopes().toArray(String[]::new));
    }
}

