/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identityprotection;

import com.microsoft.graph.identityprotection.riskdetections.RiskDetectionsRequestBuilder;
import com.microsoft.graph.identityprotection.riskyserviceprincipals.RiskyServicePrincipalsRequestBuilder;
import com.microsoft.graph.identityprotection.riskyusers.RiskyUsersRequestBuilder;
import com.microsoft.graph.identityprotection.serviceprincipalriskdetections.ServicePrincipalRiskDetectionsRequestBuilder;
import com.microsoft.graph.models.IdentityProtectionRoot;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IdentityProtectionRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public RiskDetectionsRequestBuilder riskDetections() {
        return new RiskDetectionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RiskyServicePrincipalsRequestBuilder riskyServicePrincipals() {
        return new RiskyServicePrincipalsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RiskyUsersRequestBuilder riskyUsers() {
        return new RiskyUsersRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ServicePrincipalRiskDetectionsRequestBuilder servicePrincipalRiskDetections() {
        return new ServicePrincipalRiskDetectionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public IdentityProtectionRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/identityProtection{?%24expand,%24select}", pathParameters);
    }

    public IdentityProtectionRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/identityProtection{?%24expand,%24select}", rawUrl);
    }

    @Nullable
    public IdentityProtectionRoot get() {
        return this.get(null);
    }

    @Nullable
    public IdentityProtectionRoot get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (IdentityProtectionRoot)this.requestAdapter.send(requestInfo, errorMapping, IdentityProtectionRoot::createFromDiscriminatorValue);
    }

    @Nullable
    public IdentityProtectionRoot patch(@Nonnull IdentityProtectionRoot body) {
        return this.patch(body, null);
    }

    @Nullable
    public IdentityProtectionRoot patch(@Nonnull IdentityProtectionRoot body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (IdentityProtectionRoot)this.requestAdapter.send(requestInfo, errorMapping, IdentityProtectionRoot::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull IdentityProtectionRoot body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull IdentityProtectionRoot body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public IdentityProtectionRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new IdentityProtectionRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

