/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AccessPackage;
import com.microsoft.graph.models.AccessPackageAnswer;
import com.microsoft.graph.models.AccessPackageAssignment;
import com.microsoft.graph.models.AccessPackageRequestState;
import com.microsoft.graph.models.AccessPackageRequestType;
import com.microsoft.graph.models.AccessPackageSubject;
import com.microsoft.graph.models.CustomExtensionCalloutInstance;
import com.microsoft.graph.models.EntitlementManagementSchedule;
import com.microsoft.graph.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AccessPackageAssignmentRequest
extends Entity
implements Parsable {
    @Nonnull
    public static AccessPackageAssignmentRequest createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AccessPackageAssignmentRequest();
    }

    @Nullable
    public AccessPackage getAccessPackage() {
        return (AccessPackage)this.backingStore.get("accessPackage");
    }

    @Nullable
    public List<AccessPackageAnswer> getAnswers() {
        return (List)this.backingStore.get("answers");
    }

    @Nullable
    public AccessPackageAssignment getAssignment() {
        return (AccessPackageAssignment)this.backingStore.get("assignment");
    }

    @Nullable
    public OffsetDateTime getCompletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("completedDateTime");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public List<CustomExtensionCalloutInstance> getCustomExtensionCalloutInstances() {
        return (List)this.backingStore.get("customExtensionCalloutInstances");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("accessPackage", n -> this.setAccessPackage((AccessPackage)n.getObjectValue(AccessPackage::createFromDiscriminatorValue)));
        deserializerMap.put("answers", n -> this.setAnswers(n.getCollectionOfObjectValues(AccessPackageAnswer::createFromDiscriminatorValue)));
        deserializerMap.put("assignment", n -> this.setAssignment((AccessPackageAssignment)n.getObjectValue(AccessPackageAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("completedDateTime", n -> this.setCompletedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("customExtensionCalloutInstances", n -> this.setCustomExtensionCalloutInstances(n.getCollectionOfObjectValues(CustomExtensionCalloutInstance::createFromDiscriminatorValue)));
        deserializerMap.put("requestor", n -> this.setRequestor((AccessPackageSubject)n.getObjectValue(AccessPackageSubject::createFromDiscriminatorValue)));
        deserializerMap.put("requestType", n -> this.setRequestType((AccessPackageRequestType)n.getEnumValue(AccessPackageRequestType::forValue)));
        deserializerMap.put("schedule", n -> this.setSchedule((EntitlementManagementSchedule)n.getObjectValue(EntitlementManagementSchedule::createFromDiscriminatorValue)));
        deserializerMap.put("state", n -> this.setState((AccessPackageRequestState)n.getEnumValue(AccessPackageRequestState::forValue)));
        deserializerMap.put("status", n -> this.setStatus(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public AccessPackageSubject getRequestor() {
        return (AccessPackageSubject)this.backingStore.get("requestor");
    }

    @Nullable
    public AccessPackageRequestType getRequestType() {
        return (AccessPackageRequestType)((Object)this.backingStore.get("requestType"));
    }

    @Nullable
    public EntitlementManagementSchedule getSchedule() {
        return (EntitlementManagementSchedule)this.backingStore.get("schedule");
    }

    @Nullable
    public AccessPackageRequestState getState() {
        return (AccessPackageRequestState)((Object)this.backingStore.get("state"));
    }

    @Nullable
    public String getStatus() {
        return (String)this.backingStore.get("status");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("accessPackage", (Parsable)this.getAccessPackage(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("answers", this.getAnswers());
        writer.writeObjectValue("assignment", (Parsable)this.getAssignment(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("completedDateTime", this.getCompletedDateTime());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeCollectionOfObjectValues("customExtensionCalloutInstances", this.getCustomExtensionCalloutInstances());
        writer.writeObjectValue("requestor", (Parsable)this.getRequestor(), new Parsable[0]);
        writer.writeEnumValue("requestType", (Enum)this.getRequestType());
        writer.writeObjectValue("schedule", (Parsable)this.getSchedule(), new Parsable[0]);
        writer.writeEnumValue("state", (Enum)this.getState());
        writer.writeStringValue("status", this.getStatus());
    }

    public void setAccessPackage(@Nullable AccessPackage value) {
        this.backingStore.set("accessPackage", (Object)value);
    }

    public void setAnswers(@Nullable List<AccessPackageAnswer> value) {
        this.backingStore.set("answers", value);
    }

    public void setAssignment(@Nullable AccessPackageAssignment value) {
        this.backingStore.set("assignment", (Object)value);
    }

    public void setCompletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completedDateTime", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCustomExtensionCalloutInstances(@Nullable List<CustomExtensionCalloutInstance> value) {
        this.backingStore.set("customExtensionCalloutInstances", value);
    }

    public void setRequestor(@Nullable AccessPackageSubject value) {
        this.backingStore.set("requestor", (Object)value);
    }

    public void setRequestType(@Nullable AccessPackageRequestType value) {
        this.backingStore.set("requestType", (Object)value);
    }

    public void setSchedule(@Nullable EntitlementManagementSchedule value) {
        this.backingStore.set("schedule", (Object)value);
    }

    public void setState(@Nullable AccessPackageRequestState value) {
        this.backingStore.set("state", (Object)value);
    }

    public void setStatus(@Nullable String value) {
        this.backingStore.set("status", (Object)value);
    }
}

