/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AttributeDefinitionMetadataEntry;
import com.microsoft.graph.models.AttributeType;
import com.microsoft.graph.models.Mutability;
import com.microsoft.graph.models.ReferencedObject;
import com.microsoft.graph.models.StringKeyStringValuePair;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AttributeDefinition
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AttributeDefinition() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AttributeDefinition createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AttributeDefinition();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Boolean getAnchor() {
        return (Boolean)this.backingStore.get("anchor");
    }

    @Nullable
    public List<StringKeyStringValuePair> getApiExpressions() {
        return (List)this.backingStore.get("apiExpressions");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Boolean getCaseExact() {
        return (Boolean)this.backingStore.get("caseExact");
    }

    @Nullable
    public String getDefaultValue() {
        return (String)this.backingStore.get("defaultValue");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(13);
        deserializerMap.put("anchor", n -> this.setAnchor(n.getBooleanValue()));
        deserializerMap.put("apiExpressions", n -> this.setApiExpressions(n.getCollectionOfObjectValues(StringKeyStringValuePair::createFromDiscriminatorValue)));
        deserializerMap.put("caseExact", n -> this.setCaseExact(n.getBooleanValue()));
        deserializerMap.put("defaultValue", n -> this.setDefaultValue(n.getStringValue()));
        deserializerMap.put("flowNullValues", n -> this.setFlowNullValues(n.getBooleanValue()));
        deserializerMap.put("metadata", n -> this.setMetadata(n.getCollectionOfObjectValues(AttributeDefinitionMetadataEntry::createFromDiscriminatorValue)));
        deserializerMap.put("multivalued", n -> this.setMultivalued(n.getBooleanValue()));
        deserializerMap.put("mutability", n -> this.setMutability((Mutability)n.getEnumValue(Mutability::forValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("referencedObjects", n -> this.setReferencedObjects(n.getCollectionOfObjectValues(ReferencedObject::createFromDiscriminatorValue)));
        deserializerMap.put("required", n -> this.setRequired(n.getBooleanValue()));
        deserializerMap.put("type", n -> this.setType((AttributeType)n.getEnumValue(AttributeType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getFlowNullValues() {
        return (Boolean)this.backingStore.get("flowNullValues");
    }

    @Nullable
    public List<AttributeDefinitionMetadataEntry> getMetadata() {
        return (List)this.backingStore.get("metadata");
    }

    @Nullable
    public Boolean getMultivalued() {
        return (Boolean)this.backingStore.get("multivalued");
    }

    @Nullable
    public Mutability getMutability() {
        return (Mutability)((Object)this.backingStore.get("mutability"));
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<ReferencedObject> getReferencedObjects() {
        return (List)this.backingStore.get("referencedObjects");
    }

    @Nullable
    public Boolean getRequired() {
        return (Boolean)this.backingStore.get("required");
    }

    @Nullable
    public AttributeType getType() {
        return (AttributeType)((Object)this.backingStore.get("type"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("anchor", this.getAnchor());
        writer.writeCollectionOfObjectValues("apiExpressions", this.getApiExpressions());
        writer.writeBooleanValue("caseExact", this.getCaseExact());
        writer.writeStringValue("defaultValue", this.getDefaultValue());
        writer.writeBooleanValue("flowNullValues", this.getFlowNullValues());
        writer.writeCollectionOfObjectValues("metadata", this.getMetadata());
        writer.writeBooleanValue("multivalued", this.getMultivalued());
        writer.writeEnumValue("mutability", (Enum)this.getMutability());
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("referencedObjects", this.getReferencedObjects());
        writer.writeBooleanValue("required", this.getRequired());
        writer.writeEnumValue("type", (Enum)this.getType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAnchor(@Nullable Boolean value) {
        this.backingStore.set("anchor", (Object)value);
    }

    public void setApiExpressions(@Nullable List<StringKeyStringValuePair> value) {
        this.backingStore.set("apiExpressions", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCaseExact(@Nullable Boolean value) {
        this.backingStore.set("caseExact", (Object)value);
    }

    public void setDefaultValue(@Nullable String value) {
        this.backingStore.set("defaultValue", (Object)value);
    }

    public void setFlowNullValues(@Nullable Boolean value) {
        this.backingStore.set("flowNullValues", (Object)value);
    }

    public void setMetadata(@Nullable List<AttributeDefinitionMetadataEntry> value) {
        this.backingStore.set("metadata", value);
    }

    public void setMultivalued(@Nullable Boolean value) {
        this.backingStore.set("multivalued", (Object)value);
    }

    public void setMutability(@Nullable Mutability value) {
        this.backingStore.set("mutability", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setReferencedObjects(@Nullable List<ReferencedObject> value) {
        this.backingStore.set("referencedObjects", value);
    }

    public void setRequired(@Nullable Boolean value) {
        this.backingStore.set("required", (Object)value);
    }

    public void setType(@Nullable AttributeType value) {
        this.backingStore.set("type", (Object)value);
    }
}

