/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AttributeFlowBehavior;
import com.microsoft.graph.models.AttributeFlowType;
import com.microsoft.graph.models.AttributeMappingSource;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AttributeMapping
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AttributeMapping() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AttributeMapping createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AttributeMapping();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDefaultValue() {
        return (String)this.backingStore.get("defaultValue");
    }

    @Nullable
    public Boolean getExportMissingReferences() {
        return (Boolean)this.backingStore.get("exportMissingReferences");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("defaultValue", n -> this.setDefaultValue(n.getStringValue()));
        deserializerMap.put("exportMissingReferences", n -> this.setExportMissingReferences(n.getBooleanValue()));
        deserializerMap.put("flowBehavior", n -> this.setFlowBehavior((AttributeFlowBehavior)n.getEnumValue(AttributeFlowBehavior::forValue)));
        deserializerMap.put("flowType", n -> this.setFlowType((AttributeFlowType)n.getEnumValue(AttributeFlowType::forValue)));
        deserializerMap.put("matchingPriority", n -> this.setMatchingPriority(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("source", n -> this.setSource((AttributeMappingSource)n.getObjectValue(AttributeMappingSource::createFromDiscriminatorValue)));
        deserializerMap.put("targetAttributeName", n -> this.setTargetAttributeName(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public AttributeFlowBehavior getFlowBehavior() {
        return (AttributeFlowBehavior)((Object)this.backingStore.get("flowBehavior"));
    }

    @Nullable
    public AttributeFlowType getFlowType() {
        return (AttributeFlowType)((Object)this.backingStore.get("flowType"));
    }

    @Nullable
    public Integer getMatchingPriority() {
        return (Integer)this.backingStore.get("matchingPriority");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public AttributeMappingSource getSource() {
        return (AttributeMappingSource)this.backingStore.get("source");
    }

    @Nullable
    public String getTargetAttributeName() {
        return (String)this.backingStore.get("targetAttributeName");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("defaultValue", this.getDefaultValue());
        writer.writeBooleanValue("exportMissingReferences", this.getExportMissingReferences());
        writer.writeEnumValue("flowBehavior", (Enum)this.getFlowBehavior());
        writer.writeEnumValue("flowType", (Enum)this.getFlowType());
        writer.writeIntegerValue("matchingPriority", this.getMatchingPriority());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("source", (Parsable)this.getSource(), new Parsable[0]);
        writer.writeStringValue("targetAttributeName", this.getTargetAttributeName());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDefaultValue(@Nullable String value) {
        this.backingStore.set("defaultValue", (Object)value);
    }

    public void setExportMissingReferences(@Nullable Boolean value) {
        this.backingStore.set("exportMissingReferences", (Object)value);
    }

    public void setFlowBehavior(@Nullable AttributeFlowBehavior value) {
        this.backingStore.set("flowBehavior", (Object)value);
    }

    public void setFlowType(@Nullable AttributeFlowType value) {
        this.backingStore.set("flowType", (Object)value);
    }

    public void setMatchingPriority(@Nullable Integer value) {
        this.backingStore.set("matchingPriority", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSource(@Nullable AttributeMappingSource value) {
        this.backingStore.set("source", (Object)value);
    }

    public void setTargetAttributeName(@Nullable String value) {
        this.backingStore.set("targetAttributeName", (Object)value);
    }
}

