/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EmailAddress;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.MultiValueLegacyExtendedProperty;
import com.microsoft.graph.models.OutlookItem;
import com.microsoft.graph.models.PhysicalAddress;
import com.microsoft.graph.models.ProfilePhoto;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Contact
extends OutlookItem
implements Parsable {
    public Contact() {
        this.setOdataType("#microsoft.graph.contact");
    }

    @Nonnull
    public static Contact createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Contact();
    }

    @Nullable
    public String getAssistantName() {
        return (String)this.backingStore.get("assistantName");
    }

    @Nullable
    public OffsetDateTime getBirthday() {
        return (OffsetDateTime)this.backingStore.get("birthday");
    }

    @Nullable
    public PhysicalAddress getBusinessAddress() {
        return (PhysicalAddress)this.backingStore.get("businessAddress");
    }

    @Nullable
    public String getBusinessHomePage() {
        return (String)this.backingStore.get("businessHomePage");
    }

    @Nullable
    public List<String> getBusinessPhones() {
        return (List)this.backingStore.get("businessPhones");
    }

    @Nullable
    public List<String> getChildren() {
        return (List)this.backingStore.get("children");
    }

    @Nullable
    public String getCompanyName() {
        return (String)this.backingStore.get("companyName");
    }

    @Nullable
    public String getDepartment() {
        return (String)this.backingStore.get("department");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public List<EmailAddress> getEmailAddresses() {
        return (List)this.backingStore.get("emailAddresses");
    }

    @Nullable
    public List<Extension> getExtensions() {
        return (List)this.backingStore.get("extensions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assistantName", n -> this.setAssistantName(n.getStringValue()));
        deserializerMap.put("birthday", n -> this.setBirthday(n.getOffsetDateTimeValue()));
        deserializerMap.put("businessAddress", n -> this.setBusinessAddress((PhysicalAddress)n.getObjectValue(PhysicalAddress::createFromDiscriminatorValue)));
        deserializerMap.put("businessHomePage", n -> this.setBusinessHomePage(n.getStringValue()));
        deserializerMap.put("businessPhones", n -> this.setBusinessPhones(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("children", n -> this.setChildren(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("companyName", n -> this.setCompanyName(n.getStringValue()));
        deserializerMap.put("department", n -> this.setDepartment(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("emailAddresses", n -> this.setEmailAddresses(n.getCollectionOfObjectValues(EmailAddress::createFromDiscriminatorValue)));
        deserializerMap.put("extensions", n -> this.setExtensions(n.getCollectionOfObjectValues(Extension::createFromDiscriminatorValue)));
        deserializerMap.put("fileAs", n -> this.setFileAs(n.getStringValue()));
        deserializerMap.put("generation", n -> this.setGeneration(n.getStringValue()));
        deserializerMap.put("givenName", n -> this.setGivenName(n.getStringValue()));
        deserializerMap.put("homeAddress", n -> this.setHomeAddress((PhysicalAddress)n.getObjectValue(PhysicalAddress::createFromDiscriminatorValue)));
        deserializerMap.put("homePhones", n -> this.setHomePhones(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("imAddresses", n -> this.setImAddresses(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("initials", n -> this.setInitials(n.getStringValue()));
        deserializerMap.put("jobTitle", n -> this.setJobTitle(n.getStringValue()));
        deserializerMap.put("manager", n -> this.setManager(n.getStringValue()));
        deserializerMap.put("middleName", n -> this.setMiddleName(n.getStringValue()));
        deserializerMap.put("mobilePhone", n -> this.setMobilePhone(n.getStringValue()));
        deserializerMap.put("multiValueExtendedProperties", n -> this.setMultiValueExtendedProperties(n.getCollectionOfObjectValues(MultiValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("nickName", n -> this.setNickName(n.getStringValue()));
        deserializerMap.put("officeLocation", n -> this.setOfficeLocation(n.getStringValue()));
        deserializerMap.put("otherAddress", n -> this.setOtherAddress((PhysicalAddress)n.getObjectValue(PhysicalAddress::createFromDiscriminatorValue)));
        deserializerMap.put("parentFolderId", n -> this.setParentFolderId(n.getStringValue()));
        deserializerMap.put("personalNotes", n -> this.setPersonalNotes(n.getStringValue()));
        deserializerMap.put("photo", n -> this.setPhoto((ProfilePhoto)n.getObjectValue(ProfilePhoto::createFromDiscriminatorValue)));
        deserializerMap.put("profession", n -> this.setProfession(n.getStringValue()));
        deserializerMap.put("singleValueExtendedProperties", n -> this.setSingleValueExtendedProperties(n.getCollectionOfObjectValues(SingleValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("spouseName", n -> this.setSpouseName(n.getStringValue()));
        deserializerMap.put("surname", n -> this.setSurname(n.getStringValue()));
        deserializerMap.put("title", n -> this.setTitle(n.getStringValue()));
        deserializerMap.put("yomiCompanyName", n -> this.setYomiCompanyName(n.getStringValue()));
        deserializerMap.put("yomiGivenName", n -> this.setYomiGivenName(n.getStringValue()));
        deserializerMap.put("yomiSurname", n -> this.setYomiSurname(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getFileAs() {
        return (String)this.backingStore.get("fileAs");
    }

    @Nullable
    public String getGeneration() {
        return (String)this.backingStore.get("generation");
    }

    @Nullable
    public String getGivenName() {
        return (String)this.backingStore.get("givenName");
    }

    @Nullable
    public PhysicalAddress getHomeAddress() {
        return (PhysicalAddress)this.backingStore.get("homeAddress");
    }

    @Nullable
    public List<String> getHomePhones() {
        return (List)this.backingStore.get("homePhones");
    }

    @Nullable
    public List<String> getImAddresses() {
        return (List)this.backingStore.get("imAddresses");
    }

    @Nullable
    public String getInitials() {
        return (String)this.backingStore.get("initials");
    }

    @Nullable
    public String getJobTitle() {
        return (String)this.backingStore.get("jobTitle");
    }

    @Nullable
    public String getManager() {
        return (String)this.backingStore.get("manager");
    }

    @Nullable
    public String getMiddleName() {
        return (String)this.backingStore.get("middleName");
    }

    @Nullable
    public String getMobilePhone() {
        return (String)this.backingStore.get("mobilePhone");
    }

    @Nullable
    public List<MultiValueLegacyExtendedProperty> getMultiValueExtendedProperties() {
        return (List)this.backingStore.get("multiValueExtendedProperties");
    }

    @Nullable
    public String getNickName() {
        return (String)this.backingStore.get("nickName");
    }

    @Nullable
    public String getOfficeLocation() {
        return (String)this.backingStore.get("officeLocation");
    }

    @Nullable
    public PhysicalAddress getOtherAddress() {
        return (PhysicalAddress)this.backingStore.get("otherAddress");
    }

    @Nullable
    public String getParentFolderId() {
        return (String)this.backingStore.get("parentFolderId");
    }

    @Nullable
    public String getPersonalNotes() {
        return (String)this.backingStore.get("personalNotes");
    }

    @Nullable
    public ProfilePhoto getPhoto() {
        return (ProfilePhoto)this.backingStore.get("photo");
    }

    @Nullable
    public String getProfession() {
        return (String)this.backingStore.get("profession");
    }

    @Nullable
    public List<SingleValueLegacyExtendedProperty> getSingleValueExtendedProperties() {
        return (List)this.backingStore.get("singleValueExtendedProperties");
    }

    @Nullable
    public String getSpouseName() {
        return (String)this.backingStore.get("spouseName");
    }

    @Nullable
    public String getSurname() {
        return (String)this.backingStore.get("surname");
    }

    @Nullable
    public String getTitle() {
        return (String)this.backingStore.get("title");
    }

    @Nullable
    public String getYomiCompanyName() {
        return (String)this.backingStore.get("yomiCompanyName");
    }

    @Nullable
    public String getYomiGivenName() {
        return (String)this.backingStore.get("yomiGivenName");
    }

    @Nullable
    public String getYomiSurname() {
        return (String)this.backingStore.get("yomiSurname");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("assistantName", this.getAssistantName());
        writer.writeOffsetDateTimeValue("birthday", this.getBirthday());
        writer.writeObjectValue("businessAddress", (Parsable)this.getBusinessAddress(), new Parsable[0]);
        writer.writeStringValue("businessHomePage", this.getBusinessHomePage());
        writer.writeCollectionOfPrimitiveValues("businessPhones", this.getBusinessPhones());
        writer.writeCollectionOfPrimitiveValues("children", this.getChildren());
        writer.writeStringValue("companyName", this.getCompanyName());
        writer.writeStringValue("department", this.getDepartment());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeCollectionOfObjectValues("emailAddresses", this.getEmailAddresses());
        writer.writeCollectionOfObjectValues("extensions", this.getExtensions());
        writer.writeStringValue("fileAs", this.getFileAs());
        writer.writeStringValue("generation", this.getGeneration());
        writer.writeStringValue("givenName", this.getGivenName());
        writer.writeObjectValue("homeAddress", (Parsable)this.getHomeAddress(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("homePhones", this.getHomePhones());
        writer.writeCollectionOfPrimitiveValues("imAddresses", this.getImAddresses());
        writer.writeStringValue("initials", this.getInitials());
        writer.writeStringValue("jobTitle", this.getJobTitle());
        writer.writeStringValue("manager", this.getManager());
        writer.writeStringValue("middleName", this.getMiddleName());
        writer.writeStringValue("mobilePhone", this.getMobilePhone());
        writer.writeCollectionOfObjectValues("multiValueExtendedProperties", this.getMultiValueExtendedProperties());
        writer.writeStringValue("nickName", this.getNickName());
        writer.writeStringValue("officeLocation", this.getOfficeLocation());
        writer.writeObjectValue("otherAddress", (Parsable)this.getOtherAddress(), new Parsable[0]);
        writer.writeStringValue("parentFolderId", this.getParentFolderId());
        writer.writeStringValue("personalNotes", this.getPersonalNotes());
        writer.writeObjectValue("photo", (Parsable)this.getPhoto(), new Parsable[0]);
        writer.writeStringValue("profession", this.getProfession());
        writer.writeCollectionOfObjectValues("singleValueExtendedProperties", this.getSingleValueExtendedProperties());
        writer.writeStringValue("spouseName", this.getSpouseName());
        writer.writeStringValue("surname", this.getSurname());
        writer.writeStringValue("title", this.getTitle());
        writer.writeStringValue("yomiCompanyName", this.getYomiCompanyName());
        writer.writeStringValue("yomiGivenName", this.getYomiGivenName());
        writer.writeStringValue("yomiSurname", this.getYomiSurname());
    }

    public void setAssistantName(@Nullable String value) {
        this.backingStore.set("assistantName", (Object)value);
    }

    public void setBirthday(@Nullable OffsetDateTime value) {
        this.backingStore.set("birthday", (Object)value);
    }

    public void setBusinessAddress(@Nullable PhysicalAddress value) {
        this.backingStore.set("businessAddress", (Object)value);
    }

    public void setBusinessHomePage(@Nullable String value) {
        this.backingStore.set("businessHomePage", (Object)value);
    }

    public void setBusinessPhones(@Nullable List<String> value) {
        this.backingStore.set("businessPhones", value);
    }

    public void setChildren(@Nullable List<String> value) {
        this.backingStore.set("children", value);
    }

    public void setCompanyName(@Nullable String value) {
        this.backingStore.set("companyName", (Object)value);
    }

    public void setDepartment(@Nullable String value) {
        this.backingStore.set("department", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setEmailAddresses(@Nullable List<EmailAddress> value) {
        this.backingStore.set("emailAddresses", value);
    }

    public void setExtensions(@Nullable List<Extension> value) {
        this.backingStore.set("extensions", value);
    }

    public void setFileAs(@Nullable String value) {
        this.backingStore.set("fileAs", (Object)value);
    }

    public void setGeneration(@Nullable String value) {
        this.backingStore.set("generation", (Object)value);
    }

    public void setGivenName(@Nullable String value) {
        this.backingStore.set("givenName", (Object)value);
    }

    public void setHomeAddress(@Nullable PhysicalAddress value) {
        this.backingStore.set("homeAddress", (Object)value);
    }

    public void setHomePhones(@Nullable List<String> value) {
        this.backingStore.set("homePhones", value);
    }

    public void setImAddresses(@Nullable List<String> value) {
        this.backingStore.set("imAddresses", value);
    }

    public void setInitials(@Nullable String value) {
        this.backingStore.set("initials", (Object)value);
    }

    public void setJobTitle(@Nullable String value) {
        this.backingStore.set("jobTitle", (Object)value);
    }

    public void setManager(@Nullable String value) {
        this.backingStore.set("manager", (Object)value);
    }

    public void setMiddleName(@Nullable String value) {
        this.backingStore.set("middleName", (Object)value);
    }

    public void setMobilePhone(@Nullable String value) {
        this.backingStore.set("mobilePhone", (Object)value);
    }

    public void setMultiValueExtendedProperties(@Nullable List<MultiValueLegacyExtendedProperty> value) {
        this.backingStore.set("multiValueExtendedProperties", value);
    }

    public void setNickName(@Nullable String value) {
        this.backingStore.set("nickName", (Object)value);
    }

    public void setOfficeLocation(@Nullable String value) {
        this.backingStore.set("officeLocation", (Object)value);
    }

    public void setOtherAddress(@Nullable PhysicalAddress value) {
        this.backingStore.set("otherAddress", (Object)value);
    }

    public void setParentFolderId(@Nullable String value) {
        this.backingStore.set("parentFolderId", (Object)value);
    }

    public void setPersonalNotes(@Nullable String value) {
        this.backingStore.set("personalNotes", (Object)value);
    }

    public void setPhoto(@Nullable ProfilePhoto value) {
        this.backingStore.set("photo", (Object)value);
    }

    public void setProfession(@Nullable String value) {
        this.backingStore.set("profession", (Object)value);
    }

    public void setSingleValueExtendedProperties(@Nullable List<SingleValueLegacyExtendedProperty> value) {
        this.backingStore.set("singleValueExtendedProperties", value);
    }

    public void setSpouseName(@Nullable String value) {
        this.backingStore.set("spouseName", (Object)value);
    }

    public void setSurname(@Nullable String value) {
        this.backingStore.set("surname", (Object)value);
    }

    public void setTitle(@Nullable String value) {
        this.backingStore.set("title", (Object)value);
    }

    public void setYomiCompanyName(@Nullable String value) {
        this.backingStore.set("yomiCompanyName", (Object)value);
    }

    public void setYomiGivenName(@Nullable String value) {
        this.backingStore.set("yomiGivenName", (Object)value);
    }

    public void setYomiSurname(@Nullable String value) {
        this.backingStore.set("yomiSurname", (Object)value);
    }
}

