/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.graph.models.ManagedAppDataEncryptionType;
import com.microsoft.graph.models.ManagedAppPolicyDeploymentSummary;
import com.microsoft.graph.models.ManagedAppProtection;
import com.microsoft.graph.models.ManagedMobileApp;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DefaultManagedAppProtection
extends ManagedAppProtection
implements Parsable {
    public DefaultManagedAppProtection() {
        this.setOdataType("#microsoft.graph.defaultManagedAppProtection");
    }

    @Nonnull
    public static DefaultManagedAppProtection createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DefaultManagedAppProtection();
    }

    @Nullable
    public ManagedAppDataEncryptionType getAppDataEncryptionType() {
        return (ManagedAppDataEncryptionType)((Object)this.backingStore.get("appDataEncryptionType"));
    }

    @Nullable
    public List<ManagedMobileApp> getApps() {
        return (List)this.backingStore.get("apps");
    }

    @Nullable
    public List<KeyValuePair> getCustomSettings() {
        return (List)this.backingStore.get("customSettings");
    }

    @Nullable
    public Integer getDeployedAppCount() {
        return (Integer)this.backingStore.get("deployedAppCount");
    }

    @Nullable
    public ManagedAppPolicyDeploymentSummary getDeploymentSummary() {
        return (ManagedAppPolicyDeploymentSummary)this.backingStore.get("deploymentSummary");
    }

    @Nullable
    public Boolean getDisableAppEncryptionIfDeviceEncryptionIsEnabled() {
        return (Boolean)this.backingStore.get("disableAppEncryptionIfDeviceEncryptionIsEnabled");
    }

    @Nullable
    public Boolean getEncryptAppData() {
        return (Boolean)this.backingStore.get("encryptAppData");
    }

    @Nullable
    public Boolean getFaceIdBlocked() {
        return (Boolean)this.backingStore.get("faceIdBlocked");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appDataEncryptionType", n -> this.setAppDataEncryptionType((ManagedAppDataEncryptionType)n.getEnumValue(ManagedAppDataEncryptionType::forValue)));
        deserializerMap.put("apps", n -> this.setApps(n.getCollectionOfObjectValues(ManagedMobileApp::createFromDiscriminatorValue)));
        deserializerMap.put("customSettings", n -> this.setCustomSettings(n.getCollectionOfObjectValues(KeyValuePair::createFromDiscriminatorValue)));
        deserializerMap.put("deployedAppCount", n -> this.setDeployedAppCount(n.getIntegerValue()));
        deserializerMap.put("deploymentSummary", n -> this.setDeploymentSummary((ManagedAppPolicyDeploymentSummary)n.getObjectValue(ManagedAppPolicyDeploymentSummary::createFromDiscriminatorValue)));
        deserializerMap.put("disableAppEncryptionIfDeviceEncryptionIsEnabled", n -> this.setDisableAppEncryptionIfDeviceEncryptionIsEnabled(n.getBooleanValue()));
        deserializerMap.put("encryptAppData", n -> this.setEncryptAppData(n.getBooleanValue()));
        deserializerMap.put("faceIdBlocked", n -> this.setFaceIdBlocked(n.getBooleanValue()));
        deserializerMap.put("minimumRequiredPatchVersion", n -> this.setMinimumRequiredPatchVersion(n.getStringValue()));
        deserializerMap.put("minimumRequiredSdkVersion", n -> this.setMinimumRequiredSdkVersion(n.getStringValue()));
        deserializerMap.put("minimumWarningPatchVersion", n -> this.setMinimumWarningPatchVersion(n.getStringValue()));
        deserializerMap.put("screenCaptureBlocked", n -> this.setScreenCaptureBlocked(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public String getMinimumRequiredPatchVersion() {
        return (String)this.backingStore.get("minimumRequiredPatchVersion");
    }

    @Nullable
    public String getMinimumRequiredSdkVersion() {
        return (String)this.backingStore.get("minimumRequiredSdkVersion");
    }

    @Nullable
    public String getMinimumWarningPatchVersion() {
        return (String)this.backingStore.get("minimumWarningPatchVersion");
    }

    @Nullable
    public Boolean getScreenCaptureBlocked() {
        return (Boolean)this.backingStore.get("screenCaptureBlocked");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("appDataEncryptionType", (Enum)this.getAppDataEncryptionType());
        writer.writeCollectionOfObjectValues("apps", this.getApps());
        writer.writeCollectionOfObjectValues("customSettings", this.getCustomSettings());
        writer.writeIntegerValue("deployedAppCount", this.getDeployedAppCount());
        writer.writeObjectValue("deploymentSummary", (Parsable)this.getDeploymentSummary(), new Parsable[0]);
        writer.writeBooleanValue("disableAppEncryptionIfDeviceEncryptionIsEnabled", this.getDisableAppEncryptionIfDeviceEncryptionIsEnabled());
        writer.writeBooleanValue("encryptAppData", this.getEncryptAppData());
        writer.writeBooleanValue("faceIdBlocked", this.getFaceIdBlocked());
        writer.writeStringValue("minimumRequiredPatchVersion", this.getMinimumRequiredPatchVersion());
        writer.writeStringValue("minimumRequiredSdkVersion", this.getMinimumRequiredSdkVersion());
        writer.writeStringValue("minimumWarningPatchVersion", this.getMinimumWarningPatchVersion());
        writer.writeBooleanValue("screenCaptureBlocked", this.getScreenCaptureBlocked());
    }

    public void setAppDataEncryptionType(@Nullable ManagedAppDataEncryptionType value) {
        this.backingStore.set("appDataEncryptionType", (Object)value);
    }

    public void setApps(@Nullable List<ManagedMobileApp> value) {
        this.backingStore.set("apps", value);
    }

    public void setCustomSettings(@Nullable List<KeyValuePair> value) {
        this.backingStore.set("customSettings", value);
    }

    public void setDeployedAppCount(@Nullable Integer value) {
        this.backingStore.set("deployedAppCount", (Object)value);
    }

    public void setDeploymentSummary(@Nullable ManagedAppPolicyDeploymentSummary value) {
        this.backingStore.set("deploymentSummary", (Object)value);
    }

    public void setDisableAppEncryptionIfDeviceEncryptionIsEnabled(@Nullable Boolean value) {
        this.backingStore.set("disableAppEncryptionIfDeviceEncryptionIsEnabled", (Object)value);
    }

    public void setEncryptAppData(@Nullable Boolean value) {
        this.backingStore.set("encryptAppData", (Object)value);
    }

    public void setFaceIdBlocked(@Nullable Boolean value) {
        this.backingStore.set("faceIdBlocked", (Object)value);
    }

    public void setMinimumRequiredPatchVersion(@Nullable String value) {
        this.backingStore.set("minimumRequiredPatchVersion", (Object)value);
    }

    public void setMinimumRequiredSdkVersion(@Nullable String value) {
        this.backingStore.set("minimumRequiredSdkVersion", (Object)value);
    }

    public void setMinimumWarningPatchVersion(@Nullable String value) {
        this.backingStore.set("minimumWarningPatchVersion", (Object)value);
    }

    public void setScreenCaptureBlocked(@Nullable Boolean value) {
        this.backingStore.set("screenCaptureBlocked", (Object)value);
    }
}

